package zio.aws.dynamodb.model
import scala.jdk.CollectionConverters.*
sealed trait IndexStatus {
  def unwrap: software.amazon.awssdk.services.dynamodb.model.IndexStatus
}
object IndexStatus {
  def wrap(
      value: software.amazon.awssdk.services.dynamodb.model.IndexStatus
  ): zio.aws.dynamodb.model.IndexStatus = value match {
    case software.amazon.awssdk.services.dynamodb.model.IndexStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.dynamodb.model.IndexStatus.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.dynamodb.model.IndexStatus.UPDATING =>
      val r = UPDATING
      r
    case software.amazon.awssdk.services.dynamodb.model.IndexStatus.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.dynamodb.model.IndexStatus.ACTIVE =>
      val r = ACTIVE
      r
  }
  case object unknownToSdkVersion extends zio.aws.dynamodb.model.IndexStatus {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.IndexStatus =
      software.amazon.awssdk.services.dynamodb.model.IndexStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATING extends zio.aws.dynamodb.model.IndexStatus {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.IndexStatus =
      software.amazon.awssdk.services.dynamodb.model.IndexStatus.CREATING
  }
  case object UPDATING extends zio.aws.dynamodb.model.IndexStatus {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.IndexStatus =
      software.amazon.awssdk.services.dynamodb.model.IndexStatus.UPDATING
  }
  case object DELETING extends zio.aws.dynamodb.model.IndexStatus {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.IndexStatus =
      software.amazon.awssdk.services.dynamodb.model.IndexStatus.DELETING
  }
  case object ACTIVE extends zio.aws.dynamodb.model.IndexStatus {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.IndexStatus =
      software.amazon.awssdk.services.dynamodb.model.IndexStatus.ACTIVE
  }
}
