package zio.aws.dynamodb.model
import scala.jdk.CollectionConverters.*
sealed trait InputCompressionType {
  def unwrap
      : software.amazon.awssdk.services.dynamodb.model.InputCompressionType
}
object InputCompressionType {
  def wrap(
      value: software.amazon.awssdk.services.dynamodb.model.InputCompressionType
  ): zio.aws.dynamodb.model.InputCompressionType = value match {
    case software.amazon.awssdk.services.dynamodb.model.InputCompressionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.dynamodb.model.InputCompressionType.GZIP =>
      val r = GZIP
      r
    case software.amazon.awssdk.services.dynamodb.model.InputCompressionType.ZSTD =>
      val r = ZSTD
      r
    case software.amazon.awssdk.services.dynamodb.model.InputCompressionType.NONE =>
      val r = NONE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.dynamodb.model.InputCompressionType {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.InputCompressionType =
      software.amazon.awssdk.services.dynamodb.model.InputCompressionType.UNKNOWN_TO_SDK_VERSION
  }
  case object GZIP extends zio.aws.dynamodb.model.InputCompressionType {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.InputCompressionType =
      software.amazon.awssdk.services.dynamodb.model.InputCompressionType.GZIP
  }
  case object ZSTD extends zio.aws.dynamodb.model.InputCompressionType {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.InputCompressionType =
      software.amazon.awssdk.services.dynamodb.model.InputCompressionType.ZSTD
  }
  case object NONE extends zio.aws.dynamodb.model.InputCompressionType {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.InputCompressionType =
      software.amazon.awssdk.services.dynamodb.model.InputCompressionType.NONE
  }
}
