package zio.aws.dynamodb.model
import zio.prelude.data.Optional
import zio.aws.dynamodb.model.primitives.{
  ListContributorInsightsLimit,
  NextTokenString,
  TableArn
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListContributorInsightsRequest(
    tableName: Optional[TableArn] = Optional.Absent,
    nextToken: Optional[NextTokenString] = Optional.Absent,
    maxResults: Optional[ListContributorInsightsLimit] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.ListContributorInsightsRequest = {
    import ListContributorInsightsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.ListContributorInsightsRequest
      .builder()
      .optionallyWith(
        tableName.map(value => TableArn.unwrap(value): java.lang.String)
      )(_.tableName)
      .optionallyWith(
        nextToken.map(value => NextTokenString.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value =>
          ListContributorInsightsLimit.unwrap(value): Integer
        )
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.dynamodb.model.ListContributorInsightsRequest.ReadOnly =
    zio.aws.dynamodb.model.ListContributorInsightsRequest.wrap(buildAwsValue())
}
object ListContributorInsightsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.ListContributorInsightsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.ListContributorInsightsRequest =
      zio.aws.dynamodb.model.ListContributorInsightsRequest(
        tableName.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def tableName: Optional[TableArn]
    def nextToken: Optional[NextTokenString]
    def maxResults: Optional[ListContributorInsightsLimit]
    def getTableName: ZIO[Any, AwsError, TableArn] =
      AwsError.unwrapOptionField("tableName", tableName)
    def getNextToken: ZIO[Any, AwsError, NextTokenString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, ListContributorInsightsLimit] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.ListContributorInsightsRequest
  ) extends zio.aws.dynamodb.model.ListContributorInsightsRequest.ReadOnly {
    override val tableName: Optional[TableArn] = zio.aws.core.internal
      .optionalFromNullable(impl.tableName())
      .map(value => zio.aws.dynamodb.model.primitives.TableArn(value))
    override val nextToken: Optional[NextTokenString] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.dynamodb.model.primitives.NextTokenString(value))
    override val maxResults: Optional[ListContributorInsightsLimit] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.dynamodb.model.primitives.ListContributorInsightsLimit(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.ListContributorInsightsRequest
  ): zio.aws.dynamodb.model.ListContributorInsightsRequest.ReadOnly =
    new Wrapper(impl)
}
