package zio.aws.dynamodb.model
import zio.prelude.data.Optional
import zio.aws.dynamodb.model.primitives.{
  ExportNextToken,
  ListExportsMaxLimit,
  TableArn
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListExportsRequest(
    tableArn: Optional[TableArn] = Optional.Absent,
    maxResults: Optional[ListExportsMaxLimit] = Optional.Absent,
    nextToken: Optional[ExportNextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.ListExportsRequest = {
    import ListExportsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.ListExportsRequest
      .builder()
      .optionallyWith(
        tableArn.map(value => TableArn.unwrap(value): java.lang.String)
      )(_.tableArn)
      .optionallyWith(
        maxResults.map(value => ListExportsMaxLimit.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => ExportNextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.ListExportsRequest.ReadOnly =
    zio.aws.dynamodb.model.ListExportsRequest.wrap(buildAwsValue())
}
object ListExportsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.ListExportsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.ListExportsRequest =
      zio.aws.dynamodb.model.ListExportsRequest(
        tableArn.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def tableArn: Optional[TableArn]
    def maxResults: Optional[ListExportsMaxLimit]
    def nextToken: Optional[ExportNextToken]
    def getTableArn: ZIO[Any, AwsError, TableArn] =
      AwsError.unwrapOptionField("tableArn", tableArn)
    def getMaxResults: ZIO[Any, AwsError, ListExportsMaxLimit] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, ExportNextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.ListExportsRequest
  ) extends zio.aws.dynamodb.model.ListExportsRequest.ReadOnly {
    override val tableArn: Optional[TableArn] = zio.aws.core.internal
      .optionalFromNullable(impl.tableArn())
      .map(value => zio.aws.dynamodb.model.primitives.TableArn(value))
    override val maxResults: Optional[ListExportsMaxLimit] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.dynamodb.model.primitives.ListExportsMaxLimit(value)
        )
    override val nextToken: Optional[ExportNextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.dynamodb.model.primitives.ExportNextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.ListExportsRequest
  ): zio.aws.dynamodb.model.ListExportsRequest.ReadOnly = new Wrapper(impl)
}
