package zio.aws.dynamodb.model
import zio.prelude.data.Optional
import zio.aws.dynamodb.model.primitives.{
  RegionName,
  PositiveIntegerObject,
  TableName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListGlobalTablesRequest(
    exclusiveStartGlobalTableName: Optional[TableName] = Optional.Absent,
    limit: Optional[PositiveIntegerObject] = Optional.Absent,
    regionName: Optional[RegionName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.ListGlobalTablesRequest = {
    import ListGlobalTablesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.ListGlobalTablesRequest
      .builder()
      .optionallyWith(
        exclusiveStartGlobalTableName.map(value =>
          TableName.unwrap(value): java.lang.String
        )
      )(_.exclusiveStartGlobalTableName)
      .optionallyWith(
        limit.map(value => PositiveIntegerObject.unwrap(value): Integer)
      )(_.limit)
      .optionallyWith(
        regionName.map(value => RegionName.unwrap(value): java.lang.String)
      )(_.regionName)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.ListGlobalTablesRequest.ReadOnly =
    zio.aws.dynamodb.model.ListGlobalTablesRequest.wrap(buildAwsValue())
}
object ListGlobalTablesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.ListGlobalTablesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.ListGlobalTablesRequest =
      zio.aws.dynamodb.model.ListGlobalTablesRequest(
        exclusiveStartGlobalTableName.map(value => value),
        limit.map(value => value),
        regionName.map(value => value)
      )
    def exclusiveStartGlobalTableName: Optional[TableName]
    def limit: Optional[PositiveIntegerObject]
    def regionName: Optional[RegionName]
    def getExclusiveStartGlobalTableName: ZIO[Any, AwsError, TableName] =
      AwsError.unwrapOptionField(
        "exclusiveStartGlobalTableName",
        exclusiveStartGlobalTableName
      )
    def getLimit: ZIO[Any, AwsError, PositiveIntegerObject] =
      AwsError.unwrapOptionField("limit", limit)
    def getRegionName: ZIO[Any, AwsError, RegionName] =
      AwsError.unwrapOptionField("regionName", regionName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.ListGlobalTablesRequest
  ) extends zio.aws.dynamodb.model.ListGlobalTablesRequest.ReadOnly {
    override val exclusiveStartGlobalTableName: Optional[TableName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.exclusiveStartGlobalTableName())
        .map(value => zio.aws.dynamodb.model.primitives.TableName(value))
    override val limit: Optional[PositiveIntegerObject] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value =>
        zio.aws.dynamodb.model.primitives.PositiveIntegerObject(value)
      )
    override val regionName: Optional[RegionName] = zio.aws.core.internal
      .optionalFromNullable(impl.regionName())
      .map(value => zio.aws.dynamodb.model.primitives.RegionName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.ListGlobalTablesRequest
  ): zio.aws.dynamodb.model.ListGlobalTablesRequest.ReadOnly = new Wrapper(impl)
}
