package zio.aws.dynamodb.model
import zio.prelude.data.Optional
import zio.aws.dynamodb.model.primitives.{
  ImportNextToken,
  ListImportsMaxLimit,
  TableArn
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListImportsRequest(
    tableArn: Optional[TableArn] = Optional.Absent,
    pageSize: Optional[ListImportsMaxLimit] = Optional.Absent,
    nextToken: Optional[ImportNextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.ListImportsRequest = {
    import ListImportsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.ListImportsRequest
      .builder()
      .optionallyWith(
        tableArn.map(value => TableArn.unwrap(value): java.lang.String)
      )(_.tableArn)
      .optionallyWith(
        pageSize.map(value => ListImportsMaxLimit.unwrap(value): Integer)
      )(_.pageSize)
      .optionallyWith(
        nextToken.map(value => ImportNextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.ListImportsRequest.ReadOnly =
    zio.aws.dynamodb.model.ListImportsRequest.wrap(buildAwsValue())
}
object ListImportsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.ListImportsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.ListImportsRequest =
      zio.aws.dynamodb.model.ListImportsRequest(
        tableArn.map(value => value),
        pageSize.map(value => value),
        nextToken.map(value => value)
      )
    def tableArn: Optional[TableArn]
    def pageSize: Optional[ListImportsMaxLimit]
    def nextToken: Optional[ImportNextToken]
    def getTableArn: ZIO[Any, AwsError, TableArn] =
      AwsError.unwrapOptionField("tableArn", tableArn)
    def getPageSize: ZIO[Any, AwsError, ListImportsMaxLimit] =
      AwsError.unwrapOptionField("pageSize", pageSize)
    def getNextToken: ZIO[Any, AwsError, ImportNextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.ListImportsRequest
  ) extends zio.aws.dynamodb.model.ListImportsRequest.ReadOnly {
    override val tableArn: Optional[TableArn] = zio.aws.core.internal
      .optionalFromNullable(impl.tableArn())
      .map(value => zio.aws.dynamodb.model.primitives.TableArn(value))
    override val pageSize: Optional[ListImportsMaxLimit] = zio.aws.core.internal
      .optionalFromNullable(impl.pageSize())
      .map(value =>
        zio.aws.dynamodb.model.primitives.ListImportsMaxLimit(value)
      )
    override val nextToken: Optional[ImportNextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.dynamodb.model.primitives.ImportNextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.ListImportsRequest
  ): zio.aws.dynamodb.model.ListImportsRequest.ReadOnly = new Wrapper(impl)
}
