package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.NextTokenString
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListTagsOfResourceResponse(
    tags: Optional[Iterable[zio.aws.dynamodb.model.Tag]] = Optional.Absent,
    nextToken: Optional[NextTokenString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.ListTagsOfResourceResponse = {
    import ListTagsOfResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.ListTagsOfResourceResponse
      .builder()
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        nextToken.map(value => NextTokenString.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.ListTagsOfResourceResponse.ReadOnly =
    zio.aws.dynamodb.model.ListTagsOfResourceResponse.wrap(buildAwsValue())
}
object ListTagsOfResourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.ListTagsOfResourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.ListTagsOfResourceResponse =
      zio.aws.dynamodb.model.ListTagsOfResourceResponse(
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def tags: Optional[List[zio.aws.dynamodb.model.Tag.ReadOnly]]
    def nextToken: Optional[NextTokenString]
    def getTags: ZIO[Any, AwsError, List[zio.aws.dynamodb.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getNextToken: ZIO[Any, AwsError, NextTokenString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.ListTagsOfResourceResponse
  ) extends zio.aws.dynamodb.model.ListTagsOfResourceResponse.ReadOnly {
    override val tags: Optional[List[zio.aws.dynamodb.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.dynamodb.model.Tag.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextTokenString] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.dynamodb.model.primitives.NextTokenString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.ListTagsOfResourceResponse
  ): zio.aws.dynamodb.model.ListTagsOfResourceResponse.ReadOnly = new Wrapper(
    impl
  )
}
