package zio.aws.dynamodb.model
import scala.jdk.CollectionConverters.*
sealed trait MultiRegionConsistency {
  def unwrap
      : software.amazon.awssdk.services.dynamodb.model.MultiRegionConsistency
}
object MultiRegionConsistency {
  def wrap(
      value: software.amazon.awssdk.services.dynamodb.model.MultiRegionConsistency
  ): zio.aws.dynamodb.model.MultiRegionConsistency = value match {
    case software.amazon.awssdk.services.dynamodb.model.MultiRegionConsistency.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.dynamodb.model.MultiRegionConsistency.EVENTUAL =>
      val r = EVENTUAL
      r
    case software.amazon.awssdk.services.dynamodb.model.MultiRegionConsistency.STRONG =>
      val r = STRONG
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.dynamodb.model.MultiRegionConsistency {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.MultiRegionConsistency =
      software.amazon.awssdk.services.dynamodb.model.MultiRegionConsistency.UNKNOWN_TO_SDK_VERSION
  }
  case object EVENTUAL extends zio.aws.dynamodb.model.MultiRegionConsistency {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.MultiRegionConsistency =
      software.amazon.awssdk.services.dynamodb.model.MultiRegionConsistency.EVENTUAL
  }
  case object STRONG extends zio.aws.dynamodb.model.MultiRegionConsistency {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.MultiRegionConsistency =
      software.amazon.awssdk.services.dynamodb.model.MultiRegionConsistency.STRONG
  }
}
