package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.LongObject
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class OnDemandThroughput(
    maxReadRequestUnits: Optional[LongObject] = Optional.Absent,
    maxWriteRequestUnits: Optional[LongObject] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.OnDemandThroughput = {
    import OnDemandThroughput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.OnDemandThroughput
      .builder()
      .optionallyWith(maxReadRequestUnits.map(value => value: java.lang.Long))(
        _.maxReadRequestUnits
      )
      .optionallyWith(maxWriteRequestUnits.map(value => value: java.lang.Long))(
        _.maxWriteRequestUnits
      )
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.OnDemandThroughput.ReadOnly =
    zio.aws.dynamodb.model.OnDemandThroughput.wrap(buildAwsValue())
}
object OnDemandThroughput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.OnDemandThroughput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.OnDemandThroughput =
      zio.aws.dynamodb.model.OnDemandThroughput(
        maxReadRequestUnits.map(value => value),
        maxWriteRequestUnits.map(value => value)
      )
    def maxReadRequestUnits: Optional[LongObject]
    def maxWriteRequestUnits: Optional[LongObject]
    def getMaxReadRequestUnits: ZIO[Any, AwsError, LongObject] =
      AwsError.unwrapOptionField("maxReadRequestUnits", maxReadRequestUnits)
    def getMaxWriteRequestUnits: ZIO[Any, AwsError, LongObject] =
      AwsError.unwrapOptionField("maxWriteRequestUnits", maxWriteRequestUnits)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.OnDemandThroughput
  ) extends zio.aws.dynamodb.model.OnDemandThroughput.ReadOnly {
    override val maxReadRequestUnits: Optional[LongObject] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxReadRequestUnits())
        .map(value => value: LongObject)
    override val maxWriteRequestUnits: Optional[LongObject] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxWriteRequestUnits())
        .map(value => value: LongObject)
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.OnDemandThroughput
  ): zio.aws.dynamodb.model.OnDemandThroughput.ReadOnly = new Wrapper(impl)
}
