package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.LongObject
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class OnDemandThroughputOverride(
    maxReadRequestUnits: Optional[LongObject] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.OnDemandThroughputOverride = {
    import OnDemandThroughputOverride.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.OnDemandThroughputOverride
      .builder()
      .optionallyWith(maxReadRequestUnits.map(value => value: java.lang.Long))(
        _.maxReadRequestUnits
      )
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.OnDemandThroughputOverride.ReadOnly =
    zio.aws.dynamodb.model.OnDemandThroughputOverride.wrap(buildAwsValue())
}
object OnDemandThroughputOverride {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.OnDemandThroughputOverride
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.OnDemandThroughputOverride =
      zio.aws.dynamodb.model
        .OnDemandThroughputOverride(maxReadRequestUnits.map(value => value))
    def maxReadRequestUnits: Optional[LongObject]
    def getMaxReadRequestUnits: ZIO[Any, AwsError, LongObject] =
      AwsError.unwrapOptionField("maxReadRequestUnits", maxReadRequestUnits)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.OnDemandThroughputOverride
  ) extends zio.aws.dynamodb.model.OnDemandThroughputOverride.ReadOnly {
    override val maxReadRequestUnits: Optional[LongObject] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxReadRequestUnits())
        .map(value => value: LongObject)
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.OnDemandThroughputOverride
  ): zio.aws.dynamodb.model.OnDemandThroughputOverride.ReadOnly = new Wrapper(
    impl
  )
}
