package zio.aws.dynamodb.model
import zio.prelude.data.Optional
import zio.aws.dynamodb.model.primitives.{RecoveryPeriodInDays, BooleanObject}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class PointInTimeRecoverySpecification(
    pointInTimeRecoveryEnabled: BooleanObject,
    recoveryPeriodInDays: Optional[RecoveryPeriodInDays] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.PointInTimeRecoverySpecification = {
    import PointInTimeRecoverySpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.PointInTimeRecoverySpecification
      .builder()
      .pointInTimeRecoveryEnabled(pointInTimeRecoveryEnabled: java.lang.Boolean)
      .optionallyWith(
        recoveryPeriodInDays.map(value =>
          RecoveryPeriodInDays.unwrap(value): Integer
        )
      )(_.recoveryPeriodInDays)
      .build()
  }
  def asReadOnly
      : zio.aws.dynamodb.model.PointInTimeRecoverySpecification.ReadOnly =
    zio.aws.dynamodb.model.PointInTimeRecoverySpecification
      .wrap(buildAwsValue())
}
object PointInTimeRecoverySpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.PointInTimeRecoverySpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.PointInTimeRecoverySpecification =
      zio.aws.dynamodb.model.PointInTimeRecoverySpecification(
        pointInTimeRecoveryEnabled,
        recoveryPeriodInDays.map(value => value)
      )
    def pointInTimeRecoveryEnabled: BooleanObject
    def recoveryPeriodInDays: Optional[RecoveryPeriodInDays]
    def getPointInTimeRecoveryEnabled: ZIO[Any, Nothing, BooleanObject] =
      ZIO.succeed(pointInTimeRecoveryEnabled)
    def getRecoveryPeriodInDays: ZIO[Any, AwsError, RecoveryPeriodInDays] =
      AwsError.unwrapOptionField("recoveryPeriodInDays", recoveryPeriodInDays)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.PointInTimeRecoverySpecification
  ) extends zio.aws.dynamodb.model.PointInTimeRecoverySpecification.ReadOnly {
    override val pointInTimeRecoveryEnabled: BooleanObject =
      impl.pointInTimeRecoveryEnabled(): BooleanObject
    override val recoveryPeriodInDays: Optional[RecoveryPeriodInDays] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recoveryPeriodInDays())
        .map(value =>
          zio.aws.dynamodb.model.primitives.RecoveryPeriodInDays(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.PointInTimeRecoverySpecification
  ): zio.aws.dynamodb.model.PointInTimeRecoverySpecification.ReadOnly =
    new Wrapper(impl)
}
