package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.{
  ConfirmRemoveSelfResourceAccess,
  PolicyRevisionId,
  ResourcePolicy,
  ResourceArnString
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PutResourcePolicyRequest(
    resourceArn: ResourceArnString,
    policy: ResourcePolicy,
    expectedRevisionId: Optional[PolicyRevisionId] = Optional.Absent,
    confirmRemoveSelfResourceAccess: Optional[ConfirmRemoveSelfResourceAccess] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.PutResourcePolicyRequest = {
    import PutResourcePolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.PutResourcePolicyRequest
      .builder()
      .resourceArn(ResourceArnString.unwrap(resourceArn): java.lang.String)
      .policy(ResourcePolicy.unwrap(policy): java.lang.String)
      .optionallyWith(
        expectedRevisionId.map(value =>
          PolicyRevisionId.unwrap(value): java.lang.String
        )
      )(_.expectedRevisionId)
      .optionallyWith(
        confirmRemoveSelfResourceAccess.map(value =>
          ConfirmRemoveSelfResourceAccess.unwrap(value): java.lang.Boolean
        )
      )(_.confirmRemoveSelfResourceAccess)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.PutResourcePolicyRequest.ReadOnly =
    zio.aws.dynamodb.model.PutResourcePolicyRequest.wrap(buildAwsValue())
}
object PutResourcePolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.PutResourcePolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.PutResourcePolicyRequest =
      zio.aws.dynamodb.model.PutResourcePolicyRequest(
        resourceArn,
        policy,
        expectedRevisionId.map(value => value),
        confirmRemoveSelfResourceAccess.map(value => value)
      )
    def resourceArn: ResourceArnString
    def policy: ResourcePolicy
    def expectedRevisionId: Optional[PolicyRevisionId]
    def confirmRemoveSelfResourceAccess
        : Optional[ConfirmRemoveSelfResourceAccess]
    def getResourceArn: ZIO[Any, Nothing, ResourceArnString] =
      ZIO.succeed(resourceArn)
    def getPolicy: ZIO[Any, Nothing, ResourcePolicy] = ZIO.succeed(policy)
    def getExpectedRevisionId: ZIO[Any, AwsError, PolicyRevisionId] =
      AwsError.unwrapOptionField("expectedRevisionId", expectedRevisionId)
    def getConfirmRemoveSelfResourceAccess
        : ZIO[Any, AwsError, ConfirmRemoveSelfResourceAccess] =
      AwsError.unwrapOptionField(
        "confirmRemoveSelfResourceAccess",
        confirmRemoveSelfResourceAccess
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.PutResourcePolicyRequest
  ) extends zio.aws.dynamodb.model.PutResourcePolicyRequest.ReadOnly {
    override val resourceArn: ResourceArnString =
      zio.aws.dynamodb.model.primitives.ResourceArnString(impl.resourceArn())
    override val policy: ResourcePolicy =
      zio.aws.dynamodb.model.primitives.ResourcePolicy(impl.policy())
    override val expectedRevisionId: Optional[PolicyRevisionId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expectedRevisionId())
        .map(value => zio.aws.dynamodb.model.primitives.PolicyRevisionId(value))
    override val confirmRemoveSelfResourceAccess
        : Optional[ConfirmRemoveSelfResourceAccess] = zio.aws.core.internal
      .optionalFromNullable(impl.confirmRemoveSelfResourceAccess())
      .map(value =>
        zio.aws.dynamodb.model.primitives.ConfirmRemoveSelfResourceAccess(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.PutResourcePolicyRequest
  ): zio.aws.dynamodb.model.PutResourcePolicyRequest.ReadOnly = new Wrapper(
    impl
  )
}
