package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.PolicyRevisionId
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PutResourcePolicyResponse(
    revisionId: Optional[PolicyRevisionId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.PutResourcePolicyResponse = {
    import PutResourcePolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.PutResourcePolicyResponse
      .builder()
      .optionallyWith(
        revisionId.map(value =>
          PolicyRevisionId.unwrap(value): java.lang.String
        )
      )(_.revisionId)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.PutResourcePolicyResponse.ReadOnly =
    zio.aws.dynamodb.model.PutResourcePolicyResponse.wrap(buildAwsValue())
}
object PutResourcePolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.PutResourcePolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.PutResourcePolicyResponse =
      zio.aws.dynamodb.model
        .PutResourcePolicyResponse(revisionId.map(value => value))
    def revisionId: Optional[PolicyRevisionId]
    def getRevisionId: ZIO[Any, AwsError, PolicyRevisionId] =
      AwsError.unwrapOptionField("revisionId", revisionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.PutResourcePolicyResponse
  ) extends zio.aws.dynamodb.model.PutResourcePolicyResponse.ReadOnly {
    override val revisionId: Optional[PolicyRevisionId] = zio.aws.core.internal
      .optionalFromNullable(impl.revisionId())
      .map(value => zio.aws.dynamodb.model.primitives.PolicyRevisionId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.PutResourcePolicyResponse
  ): zio.aws.dynamodb.model.PutResourcePolicyResponse.ReadOnly = new Wrapper(
    impl
  )
}
