package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.IndexName
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ReplicaGlobalSecondaryIndex(
    indexName: IndexName,
    provisionedThroughputOverride: Optional[
      zio.aws.dynamodb.model.ProvisionedThroughputOverride
    ] = Optional.Absent,
    onDemandThroughputOverride: Optional[
      zio.aws.dynamodb.model.OnDemandThroughputOverride
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.ReplicaGlobalSecondaryIndex = {
    import ReplicaGlobalSecondaryIndex.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.ReplicaGlobalSecondaryIndex
      .builder()
      .indexName(IndexName.unwrap(indexName): java.lang.String)
      .optionallyWith(
        provisionedThroughputOverride.map(value => value.buildAwsValue())
      )(_.provisionedThroughputOverride)
      .optionallyWith(
        onDemandThroughputOverride.map(value => value.buildAwsValue())
      )(_.onDemandThroughputOverride)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndex.ReadOnly =
    zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndex.wrap(buildAwsValue())
}
object ReplicaGlobalSecondaryIndex {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.ReplicaGlobalSecondaryIndex
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndex =
      zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndex(
        indexName,
        provisionedThroughputOverride.map(value => value.asEditable),
        onDemandThroughputOverride.map(value => value.asEditable)
      )
    def indexName: IndexName
    def provisionedThroughputOverride: Optional[
      zio.aws.dynamodb.model.ProvisionedThroughputOverride.ReadOnly
    ]
    def onDemandThroughputOverride
        : Optional[zio.aws.dynamodb.model.OnDemandThroughputOverride.ReadOnly]
    def getIndexName: ZIO[Any, Nothing, IndexName] = ZIO.succeed(indexName)
    def getProvisionedThroughputOverride: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.ProvisionedThroughputOverride.ReadOnly
    ] = AwsError.unwrapOptionField(
      "provisionedThroughputOverride",
      provisionedThroughputOverride
    )
    def getOnDemandThroughputOverride: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.OnDemandThroughputOverride.ReadOnly
    ] = AwsError.unwrapOptionField(
      "onDemandThroughputOverride",
      onDemandThroughputOverride
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.ReplicaGlobalSecondaryIndex
  ) extends zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndex.ReadOnly {
    override val indexName: IndexName =
      zio.aws.dynamodb.model.primitives.IndexName(impl.indexName())
    override val provisionedThroughputOverride: Optional[
      zio.aws.dynamodb.model.ProvisionedThroughputOverride.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.provisionedThroughputOverride())
      .map(value =>
        zio.aws.dynamodb.model.ProvisionedThroughputOverride.wrap(value)
      )
    override val onDemandThroughputOverride
        : Optional[zio.aws.dynamodb.model.OnDemandThroughputOverride.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.onDemandThroughputOverride())
        .map(value =>
          zio.aws.dynamodb.model.OnDemandThroughputOverride.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.ReplicaGlobalSecondaryIndex
  ): zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndex.ReadOnly = new Wrapper(
    impl
  )
}
