package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.IndexName
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ReplicaGlobalSecondaryIndexDescription(
    indexName: Optional[IndexName] = Optional.Absent,
    provisionedThroughputOverride: Optional[
      zio.aws.dynamodb.model.ProvisionedThroughputOverride
    ] = Optional.Absent,
    onDemandThroughputOverride: Optional[
      zio.aws.dynamodb.model.OnDemandThroughputOverride
    ] = Optional.Absent,
    warmThroughput: Optional[
      zio.aws.dynamodb.model.GlobalSecondaryIndexWarmThroughputDescription
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.ReplicaGlobalSecondaryIndexDescription = {
    import ReplicaGlobalSecondaryIndexDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.ReplicaGlobalSecondaryIndexDescription
      .builder()
      .optionallyWith(
        indexName.map(value => IndexName.unwrap(value): java.lang.String)
      )(_.indexName)
      .optionallyWith(
        provisionedThroughputOverride.map(value => value.buildAwsValue())
      )(_.provisionedThroughputOverride)
      .optionallyWith(
        onDemandThroughputOverride.map(value => value.buildAwsValue())
      )(_.onDemandThroughputOverride)
      .optionallyWith(warmThroughput.map(value => value.buildAwsValue()))(
        _.warmThroughput
      )
      .build()
  }
  def asReadOnly
      : zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexDescription.ReadOnly =
    zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexDescription
      .wrap(buildAwsValue())
}
object ReplicaGlobalSecondaryIndexDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.ReplicaGlobalSecondaryIndexDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexDescription =
      zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexDescription(
        indexName.map(value => value),
        provisionedThroughputOverride.map(value => value.asEditable),
        onDemandThroughputOverride.map(value => value.asEditable),
        warmThroughput.map(value => value.asEditable)
      )
    def indexName: Optional[IndexName]
    def provisionedThroughputOverride: Optional[
      zio.aws.dynamodb.model.ProvisionedThroughputOverride.ReadOnly
    ]
    def onDemandThroughputOverride
        : Optional[zio.aws.dynamodb.model.OnDemandThroughputOverride.ReadOnly]
    def warmThroughput: Optional[
      zio.aws.dynamodb.model.GlobalSecondaryIndexWarmThroughputDescription.ReadOnly
    ]
    def getIndexName: ZIO[Any, AwsError, IndexName] =
      AwsError.unwrapOptionField("indexName", indexName)
    def getProvisionedThroughputOverride: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.ProvisionedThroughputOverride.ReadOnly
    ] = AwsError.unwrapOptionField(
      "provisionedThroughputOverride",
      provisionedThroughputOverride
    )
    def getOnDemandThroughputOverride: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.OnDemandThroughputOverride.ReadOnly
    ] = AwsError.unwrapOptionField(
      "onDemandThroughputOverride",
      onDemandThroughputOverride
    )
    def getWarmThroughput: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.GlobalSecondaryIndexWarmThroughputDescription.ReadOnly
    ] = AwsError.unwrapOptionField("warmThroughput", warmThroughput)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.ReplicaGlobalSecondaryIndexDescription
  ) extends zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexDescription.ReadOnly {
    override val indexName: Optional[IndexName] = zio.aws.core.internal
      .optionalFromNullable(impl.indexName())
      .map(value => zio.aws.dynamodb.model.primitives.IndexName(value))
    override val provisionedThroughputOverride: Optional[
      zio.aws.dynamodb.model.ProvisionedThroughputOverride.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.provisionedThroughputOverride())
      .map(value =>
        zio.aws.dynamodb.model.ProvisionedThroughputOverride.wrap(value)
      )
    override val onDemandThroughputOverride
        : Optional[zio.aws.dynamodb.model.OnDemandThroughputOverride.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.onDemandThroughputOverride())
        .map(value =>
          zio.aws.dynamodb.model.OnDemandThroughputOverride.wrap(value)
        )
    override val warmThroughput: Optional[
      zio.aws.dynamodb.model.GlobalSecondaryIndexWarmThroughputDescription.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.warmThroughput())
      .map(value =>
        zio.aws.dynamodb.model.GlobalSecondaryIndexWarmThroughputDescription
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.ReplicaGlobalSecondaryIndexDescription
  ): zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexDescription.ReadOnly =
    new Wrapper(impl)
}
