package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.{PositiveLongObject, IndexName}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ReplicaGlobalSecondaryIndexSettingsUpdate(
    indexName: IndexName,
    provisionedReadCapacityUnits: Optional[PositiveLongObject] =
      Optional.Absent,
    provisionedReadCapacityAutoScalingSettingsUpdate: Optional[
      zio.aws.dynamodb.model.AutoScalingSettingsUpdate
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.ReplicaGlobalSecondaryIndexSettingsUpdate = {
    import ReplicaGlobalSecondaryIndexSettingsUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.ReplicaGlobalSecondaryIndexSettingsUpdate
      .builder()
      .indexName(IndexName.unwrap(indexName): java.lang.String)
      .optionallyWith(
        provisionedReadCapacityUnits.map(value =>
          PositiveLongObject.unwrap(value): java.lang.Long
        )
      )(_.provisionedReadCapacityUnits)
      .optionallyWith(
        provisionedReadCapacityAutoScalingSettingsUpdate.map(value =>
          value.buildAwsValue()
        )
      )(_.provisionedReadCapacityAutoScalingSettingsUpdate)
      .build()
  }
  def asReadOnly
      : zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexSettingsUpdate.ReadOnly =
    zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexSettingsUpdate
      .wrap(buildAwsValue())
}
object ReplicaGlobalSecondaryIndexSettingsUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.ReplicaGlobalSecondaryIndexSettingsUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexSettingsUpdate =
      zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexSettingsUpdate(
        indexName,
        provisionedReadCapacityUnits.map(value => value),
        provisionedReadCapacityAutoScalingSettingsUpdate.map(value =>
          value.asEditable
        )
      )
    def indexName: IndexName
    def provisionedReadCapacityUnits: Optional[PositiveLongObject]
    def provisionedReadCapacityAutoScalingSettingsUpdate
        : Optional[zio.aws.dynamodb.model.AutoScalingSettingsUpdate.ReadOnly]
    def getIndexName: ZIO[Any, Nothing, IndexName] = ZIO.succeed(indexName)
    def getProvisionedReadCapacityUnits
        : ZIO[Any, AwsError, PositiveLongObject] = AwsError.unwrapOptionField(
      "provisionedReadCapacityUnits",
      provisionedReadCapacityUnits
    )
    def getProvisionedReadCapacityAutoScalingSettingsUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.AutoScalingSettingsUpdate.ReadOnly
    ] = AwsError.unwrapOptionField(
      "provisionedReadCapacityAutoScalingSettingsUpdate",
      provisionedReadCapacityAutoScalingSettingsUpdate
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.ReplicaGlobalSecondaryIndexSettingsUpdate
  ) extends zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexSettingsUpdate.ReadOnly {
    override val indexName: IndexName =
      zio.aws.dynamodb.model.primitives.IndexName(impl.indexName())
    override val provisionedReadCapacityUnits: Optional[PositiveLongObject] =
      zio.aws.core.internal
        .optionalFromNullable(impl.provisionedReadCapacityUnits())
        .map(value =>
          zio.aws.dynamodb.model.primitives.PositiveLongObject(value)
        )
    override val provisionedReadCapacityAutoScalingSettingsUpdate
        : Optional[zio.aws.dynamodb.model.AutoScalingSettingsUpdate.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(
          impl.provisionedReadCapacityAutoScalingSettingsUpdate()
        )
        .map(value =>
          zio.aws.dynamodb.model.AutoScalingSettingsUpdate.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.ReplicaGlobalSecondaryIndexSettingsUpdate
  ): zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexSettingsUpdate.ReadOnly =
    new Wrapper(impl)
}
