package zio.aws.dynamodb.model
import scala.jdk.CollectionConverters.*
sealed trait ReplicaStatus {
  def unwrap: software.amazon.awssdk.services.dynamodb.model.ReplicaStatus
}
object ReplicaStatus {
  def wrap(
      value: software.amazon.awssdk.services.dynamodb.model.ReplicaStatus
  ): zio.aws.dynamodb.model.ReplicaStatus = value match {
    case software.amazon.awssdk.services.dynamodb.model.ReplicaStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.dynamodb.model.ReplicaStatus.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.dynamodb.model.ReplicaStatus.CREATION_FAILED =>
      val r = CREATION_FAILED
      r
    case software.amazon.awssdk.services.dynamodb.model.ReplicaStatus.UPDATING =>
      val r = UPDATING
      r
    case software.amazon.awssdk.services.dynamodb.model.ReplicaStatus.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.dynamodb.model.ReplicaStatus.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.dynamodb.model.ReplicaStatus.REGION_DISABLED =>
      val r = REGION_DISABLED
      r
    case software.amazon.awssdk.services.dynamodb.model.ReplicaStatus.INACCESSIBLE_ENCRYPTION_CREDENTIALS =>
      val r = INACCESSIBLE_ENCRYPTION_CREDENTIALS
      r
  }
  case object unknownToSdkVersion extends zio.aws.dynamodb.model.ReplicaStatus {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.ReplicaStatus =
      software.amazon.awssdk.services.dynamodb.model.ReplicaStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATING extends zio.aws.dynamodb.model.ReplicaStatus {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.ReplicaStatus =
      software.amazon.awssdk.services.dynamodb.model.ReplicaStatus.CREATING
  }
  case object CREATION_FAILED extends zio.aws.dynamodb.model.ReplicaStatus {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.ReplicaStatus =
      software.amazon.awssdk.services.dynamodb.model.ReplicaStatus.CREATION_FAILED
  }
  case object UPDATING extends zio.aws.dynamodb.model.ReplicaStatus {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.ReplicaStatus =
      software.amazon.awssdk.services.dynamodb.model.ReplicaStatus.UPDATING
  }
  case object DELETING extends zio.aws.dynamodb.model.ReplicaStatus {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.ReplicaStatus =
      software.amazon.awssdk.services.dynamodb.model.ReplicaStatus.DELETING
  }
  case object ACTIVE extends zio.aws.dynamodb.model.ReplicaStatus {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.ReplicaStatus =
      software.amazon.awssdk.services.dynamodb.model.ReplicaStatus.ACTIVE
  }
  case object REGION_DISABLED extends zio.aws.dynamodb.model.ReplicaStatus {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.ReplicaStatus =
      software.amazon.awssdk.services.dynamodb.model.ReplicaStatus.REGION_DISABLED
  }
  case object INACCESSIBLE_ENCRYPTION_CREDENTIALS
      extends zio.aws.dynamodb.model.ReplicaStatus {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.ReplicaStatus =
      software.amazon.awssdk.services.dynamodb.model.ReplicaStatus.INACCESSIBLE_ENCRYPTION_CREDENTIALS
  }
}
