package zio.aws.dynamodb.model
import scala.jdk.CollectionConverters.*
sealed trait ReturnValue {
  def unwrap: software.amazon.awssdk.services.dynamodb.model.ReturnValue
}
object ReturnValue {
  def wrap(
      value: software.amazon.awssdk.services.dynamodb.model.ReturnValue
  ): zio.aws.dynamodb.model.ReturnValue = value match {
    case software.amazon.awssdk.services.dynamodb.model.ReturnValue.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.dynamodb.model.ReturnValue.NONE =>
      val r = NONE
      r
    case software.amazon.awssdk.services.dynamodb.model.ReturnValue.ALL_OLD =>
      val r = ALL_OLD
      r
    case software.amazon.awssdk.services.dynamodb.model.ReturnValue.UPDATED_OLD =>
      val r = UPDATED_OLD
      r
    case software.amazon.awssdk.services.dynamodb.model.ReturnValue.ALL_NEW =>
      val r = ALL_NEW
      r
    case software.amazon.awssdk.services.dynamodb.model.ReturnValue.UPDATED_NEW =>
      val r = UPDATED_NEW
      r
  }
  case object unknownToSdkVersion extends zio.aws.dynamodb.model.ReturnValue {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.ReturnValue =
      software.amazon.awssdk.services.dynamodb.model.ReturnValue.UNKNOWN_TO_SDK_VERSION
  }
  case object NONE extends zio.aws.dynamodb.model.ReturnValue {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.ReturnValue =
      software.amazon.awssdk.services.dynamodb.model.ReturnValue.NONE
  }
  case object ALL_OLD extends zio.aws.dynamodb.model.ReturnValue {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.ReturnValue =
      software.amazon.awssdk.services.dynamodb.model.ReturnValue.ALL_OLD
  }
  case object UPDATED_OLD extends zio.aws.dynamodb.model.ReturnValue {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.ReturnValue =
      software.amazon.awssdk.services.dynamodb.model.ReturnValue.UPDATED_OLD
  }
  case object ALL_NEW extends zio.aws.dynamodb.model.ReturnValue {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.ReturnValue =
      software.amazon.awssdk.services.dynamodb.model.ReturnValue.ALL_NEW
  }
  case object UPDATED_NEW extends zio.aws.dynamodb.model.ReturnValue {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.ReturnValue =
      software.amazon.awssdk.services.dynamodb.model.ReturnValue.UPDATED_NEW
  }
}
