package zio.aws.dynamodb.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.dynamodb.model.primitives.{
  TableName,
  LongObject,
  ItemCount,
  TableArn,
  TableCreationDateTime,
  TableId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class SourceTableDetails(
    tableName: TableName,
    tableId: TableId,
    tableArn: Optional[TableArn] = Optional.Absent,
    tableSizeBytes: Optional[LongObject] = Optional.Absent,
    keySchema: Iterable[zio.aws.dynamodb.model.KeySchemaElement],
    tableCreationDateTime: TableCreationDateTime,
    provisionedThroughput: zio.aws.dynamodb.model.ProvisionedThroughput,
    onDemandThroughput: Optional[zio.aws.dynamodb.model.OnDemandThroughput] =
      Optional.Absent,
    itemCount: Optional[ItemCount] = Optional.Absent,
    billingMode: Optional[zio.aws.dynamodb.model.BillingMode] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.SourceTableDetails = {
    import SourceTableDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.SourceTableDetails
      .builder()
      .tableName(TableName.unwrap(tableName): java.lang.String)
      .tableId(TableId.unwrap(tableId): java.lang.String)
      .optionallyWith(
        tableArn.map(value => TableArn.unwrap(value): java.lang.String)
      )(_.tableArn)
      .optionallyWith(tableSizeBytes.map(value => value: java.lang.Long))(
        _.tableSizeBytes
      )
      .keySchema(keySchema.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .tableCreationDateTime(
        TableCreationDateTime.unwrap(tableCreationDateTime): Instant
      )
      .provisionedThroughput(provisionedThroughput.buildAwsValue())
      .optionallyWith(onDemandThroughput.map(value => value.buildAwsValue()))(
        _.onDemandThroughput
      )
      .optionallyWith(
        itemCount.map(value => ItemCount.unwrap(value): java.lang.Long)
      )(_.itemCount)
      .optionallyWith(billingMode.map(value => value.unwrap))(_.billingMode)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.SourceTableDetails.ReadOnly =
    zio.aws.dynamodb.model.SourceTableDetails.wrap(buildAwsValue())
}
object SourceTableDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.SourceTableDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.SourceTableDetails =
      zio.aws.dynamodb.model.SourceTableDetails(
        tableName,
        tableId,
        tableArn.map(value => value),
        tableSizeBytes.map(value => value),
        keySchema.map { item =>
          item.asEditable
        },
        tableCreationDateTime,
        provisionedThroughput.asEditable,
        onDemandThroughput.map(value => value.asEditable),
        itemCount.map(value => value),
        billingMode.map(value => value)
      )
    def tableName: TableName
    def tableId: TableId
    def tableArn: Optional[TableArn]
    def tableSizeBytes: Optional[LongObject]
    def keySchema: List[zio.aws.dynamodb.model.KeySchemaElement.ReadOnly]
    def tableCreationDateTime: TableCreationDateTime
    def provisionedThroughput
        : zio.aws.dynamodb.model.ProvisionedThroughput.ReadOnly
    def onDemandThroughput
        : Optional[zio.aws.dynamodb.model.OnDemandThroughput.ReadOnly]
    def itemCount: Optional[ItemCount]
    def billingMode: Optional[zio.aws.dynamodb.model.BillingMode]
    def getTableName: ZIO[Any, Nothing, TableName] = ZIO.succeed(tableName)
    def getTableId: ZIO[Any, Nothing, TableId] = ZIO.succeed(tableId)
    def getTableArn: ZIO[Any, AwsError, TableArn] =
      AwsError.unwrapOptionField("tableArn", tableArn)
    def getTableSizeBytes: ZIO[Any, AwsError, LongObject] =
      AwsError.unwrapOptionField("tableSizeBytes", tableSizeBytes)
    def getKeySchema: ZIO[Any, Nothing, List[
      zio.aws.dynamodb.model.KeySchemaElement.ReadOnly
    ]] = ZIO.succeed(keySchema)
    def getTableCreationDateTime: ZIO[Any, Nothing, TableCreationDateTime] =
      ZIO.succeed(tableCreationDateTime)
    def getProvisionedThroughput: ZIO[
      Any,
      Nothing,
      zio.aws.dynamodb.model.ProvisionedThroughput.ReadOnly
    ] = ZIO.succeed(provisionedThroughput)
    def getOnDemandThroughput: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.OnDemandThroughput.ReadOnly
    ] = AwsError.unwrapOptionField("onDemandThroughput", onDemandThroughput)
    def getItemCount: ZIO[Any, AwsError, ItemCount] =
      AwsError.unwrapOptionField("itemCount", itemCount)
    def getBillingMode: ZIO[Any, AwsError, zio.aws.dynamodb.model.BillingMode] =
      AwsError.unwrapOptionField("billingMode", billingMode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.SourceTableDetails
  ) extends zio.aws.dynamodb.model.SourceTableDetails.ReadOnly {
    override val tableName: TableName =
      zio.aws.dynamodb.model.primitives.TableName(impl.tableName())
    override val tableId: TableId =
      zio.aws.dynamodb.model.primitives.TableId(impl.tableId())
    override val tableArn: Optional[TableArn] = zio.aws.core.internal
      .optionalFromNullable(impl.tableArn())
      .map(value => zio.aws.dynamodb.model.primitives.TableArn(value))
    override val tableSizeBytes: Optional[LongObject] = zio.aws.core.internal
      .optionalFromNullable(impl.tableSizeBytes())
      .map(value => value: LongObject)
    override val keySchema
        : List[zio.aws.dynamodb.model.KeySchemaElement.ReadOnly] = impl
      .keySchema()
      .asScala
      .map { item =>
        zio.aws.dynamodb.model.KeySchemaElement.wrap(item)
      }
      .toList
    override val tableCreationDateTime: TableCreationDateTime =
      zio.aws.dynamodb.model.primitives
        .TableCreationDateTime(impl.tableCreationDateTime())
    override val provisionedThroughput
        : zio.aws.dynamodb.model.ProvisionedThroughput.ReadOnly =
      zio.aws.dynamodb.model.ProvisionedThroughput
        .wrap(impl.provisionedThroughput())
    override val onDemandThroughput
        : Optional[zio.aws.dynamodb.model.OnDemandThroughput.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.onDemandThroughput())
        .map(value => zio.aws.dynamodb.model.OnDemandThroughput.wrap(value))
    override val itemCount: Optional[ItemCount] = zio.aws.core.internal
      .optionalFromNullable(impl.itemCount())
      .map(value => zio.aws.dynamodb.model.primitives.ItemCount(value))
    override val billingMode: Optional[zio.aws.dynamodb.model.BillingMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.billingMode())
        .map(value => zio.aws.dynamodb.model.BillingMode.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.SourceTableDetails
  ): zio.aws.dynamodb.model.SourceTableDetails.ReadOnly = new Wrapper(impl)
}
