package zio.aws.dynamodb.model
import scala.jdk.CollectionConverters.*
sealed trait StreamViewType {
  def unwrap: software.amazon.awssdk.services.dynamodb.model.StreamViewType
}
object StreamViewType {
  def wrap(
      value: software.amazon.awssdk.services.dynamodb.model.StreamViewType
  ): zio.aws.dynamodb.model.StreamViewType = value match {
    case software.amazon.awssdk.services.dynamodb.model.StreamViewType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.dynamodb.model.StreamViewType.NEW_IMAGE =>
      val r = NEW_IMAGE
      r
    case software.amazon.awssdk.services.dynamodb.model.StreamViewType.OLD_IMAGE =>
      val r = OLD_IMAGE
      r
    case software.amazon.awssdk.services.dynamodb.model.StreamViewType.NEW_AND_OLD_IMAGES =>
      val r = NEW_AND_OLD_IMAGES
      r
    case software.amazon.awssdk.services.dynamodb.model.StreamViewType.KEYS_ONLY =>
      val r = KEYS_ONLY
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.dynamodb.model.StreamViewType {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.StreamViewType =
      software.amazon.awssdk.services.dynamodb.model.StreamViewType.UNKNOWN_TO_SDK_VERSION
  }
  case object NEW_IMAGE extends zio.aws.dynamodb.model.StreamViewType {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.StreamViewType =
      software.amazon.awssdk.services.dynamodb.model.StreamViewType.NEW_IMAGE
  }
  case object OLD_IMAGE extends zio.aws.dynamodb.model.StreamViewType {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.StreamViewType =
      software.amazon.awssdk.services.dynamodb.model.StreamViewType.OLD_IMAGE
  }
  case object NEW_AND_OLD_IMAGES extends zio.aws.dynamodb.model.StreamViewType {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.StreamViewType =
      software.amazon.awssdk.services.dynamodb.model.StreamViewType.NEW_AND_OLD_IMAGES
  }
  case object KEYS_ONLY extends zio.aws.dynamodb.model.StreamViewType {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.StreamViewType =
      software.amazon.awssdk.services.dynamodb.model.StreamViewType.KEYS_ONLY
  }
}
