package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.PositiveLongObject
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class TableWarmThroughputDescription(
    readUnitsPerSecond: Optional[PositiveLongObject] = Optional.Absent,
    writeUnitsPerSecond: Optional[PositiveLongObject] = Optional.Absent,
    status: Optional[zio.aws.dynamodb.model.TableStatus] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.TableWarmThroughputDescription = {
    import TableWarmThroughputDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.TableWarmThroughputDescription
      .builder()
      .optionallyWith(
        readUnitsPerSecond.map(value =>
          PositiveLongObject.unwrap(value): java.lang.Long
        )
      )(_.readUnitsPerSecond)
      .optionallyWith(
        writeUnitsPerSecond.map(value =>
          PositiveLongObject.unwrap(value): java.lang.Long
        )
      )(_.writeUnitsPerSecond)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.dynamodb.model.TableWarmThroughputDescription.ReadOnly =
    zio.aws.dynamodb.model.TableWarmThroughputDescription.wrap(buildAwsValue())
}
object TableWarmThroughputDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.TableWarmThroughputDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.TableWarmThroughputDescription =
      zio.aws.dynamodb.model.TableWarmThroughputDescription(
        readUnitsPerSecond.map(value => value),
        writeUnitsPerSecond.map(value => value),
        status.map(value => value)
      )
    def readUnitsPerSecond: Optional[PositiveLongObject]
    def writeUnitsPerSecond: Optional[PositiveLongObject]
    def status: Optional[zio.aws.dynamodb.model.TableStatus]
    def getReadUnitsPerSecond: ZIO[Any, AwsError, PositiveLongObject] =
      AwsError.unwrapOptionField("readUnitsPerSecond", readUnitsPerSecond)
    def getWriteUnitsPerSecond: ZIO[Any, AwsError, PositiveLongObject] =
      AwsError.unwrapOptionField("writeUnitsPerSecond", writeUnitsPerSecond)
    def getStatus: ZIO[Any, AwsError, zio.aws.dynamodb.model.TableStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.TableWarmThroughputDescription
  ) extends zio.aws.dynamodb.model.TableWarmThroughputDescription.ReadOnly {
    override val readUnitsPerSecond: Optional[PositiveLongObject] =
      zio.aws.core.internal
        .optionalFromNullable(impl.readUnitsPerSecond())
        .map(value =>
          zio.aws.dynamodb.model.primitives.PositiveLongObject(value)
        )
    override val writeUnitsPerSecond: Optional[PositiveLongObject] =
      zio.aws.core.internal
        .optionalFromNullable(impl.writeUnitsPerSecond())
        .map(value =>
          zio.aws.dynamodb.model.primitives.PositiveLongObject(value)
        )
    override val status: Optional[zio.aws.dynamodb.model.TableStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.dynamodb.model.TableStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.TableWarmThroughputDescription
  ): zio.aws.dynamodb.model.TableWarmThroughputDescription.ReadOnly =
    new Wrapper(impl)
}
