package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateContinuousBackupsResponse(
    continuousBackupsDescription: Optional[
      zio.aws.dynamodb.model.ContinuousBackupsDescription
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.UpdateContinuousBackupsResponse = {
    import UpdateContinuousBackupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.UpdateContinuousBackupsResponse
      .builder()
      .optionallyWith(
        continuousBackupsDescription.map(value => value.buildAwsValue())
      )(_.continuousBackupsDescription)
      .build()
  }
  def asReadOnly
      : zio.aws.dynamodb.model.UpdateContinuousBackupsResponse.ReadOnly =
    zio.aws.dynamodb.model.UpdateContinuousBackupsResponse.wrap(buildAwsValue())
}
object UpdateContinuousBackupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.UpdateContinuousBackupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.UpdateContinuousBackupsResponse =
      zio.aws.dynamodb.model.UpdateContinuousBackupsResponse(
        continuousBackupsDescription.map(value => value.asEditable)
      )
    def continuousBackupsDescription
        : Optional[zio.aws.dynamodb.model.ContinuousBackupsDescription.ReadOnly]
    def getContinuousBackupsDescription: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.ContinuousBackupsDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "continuousBackupsDescription",
      continuousBackupsDescription
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.UpdateContinuousBackupsResponse
  ) extends zio.aws.dynamodb.model.UpdateContinuousBackupsResponse.ReadOnly {
    override val continuousBackupsDescription: Optional[
      zio.aws.dynamodb.model.ContinuousBackupsDescription.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.continuousBackupsDescription())
      .map(value =>
        zio.aws.dynamodb.model.ContinuousBackupsDescription.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.UpdateContinuousBackupsResponse
  ): zio.aws.dynamodb.model.UpdateContinuousBackupsResponse.ReadOnly =
    new Wrapper(impl)
}
