package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.dynamodb.model.primitives.TableName
import scala.jdk.CollectionConverters.*
final case class UpdateGlobalTableRequest(
    globalTableName: TableName,
    replicaUpdates: Iterable[zio.aws.dynamodb.model.ReplicaUpdate]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.UpdateGlobalTableRequest = {
    import UpdateGlobalTableRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.UpdateGlobalTableRequest
      .builder()
      .globalTableName(TableName.unwrap(globalTableName): java.lang.String)
      .replicaUpdates(replicaUpdates.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.UpdateGlobalTableRequest.ReadOnly =
    zio.aws.dynamodb.model.UpdateGlobalTableRequest.wrap(buildAwsValue())
}
object UpdateGlobalTableRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.UpdateGlobalTableRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.UpdateGlobalTableRequest =
      zio.aws.dynamodb.model.UpdateGlobalTableRequest(
        globalTableName,
        replicaUpdates.map { item =>
          item.asEditable
        }
      )
    def globalTableName: TableName
    def replicaUpdates: List[zio.aws.dynamodb.model.ReplicaUpdate.ReadOnly]
    def getGlobalTableName: ZIO[Any, Nothing, TableName] =
      ZIO.succeed(globalTableName)
    def getReplicaUpdates: ZIO[Any, Nothing, List[
      zio.aws.dynamodb.model.ReplicaUpdate.ReadOnly
    ]] = ZIO.succeed(replicaUpdates)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.UpdateGlobalTableRequest
  ) extends zio.aws.dynamodb.model.UpdateGlobalTableRequest.ReadOnly {
    override val globalTableName: TableName =
      zio.aws.dynamodb.model.primitives.TableName(impl.globalTableName())
    override val replicaUpdates
        : List[zio.aws.dynamodb.model.ReplicaUpdate.ReadOnly] = impl
      .replicaUpdates()
      .asScala
      .map { item =>
        zio.aws.dynamodb.model.ReplicaUpdate.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.UpdateGlobalTableRequest
  ): zio.aws.dynamodb.model.UpdateGlobalTableRequest.ReadOnly = new Wrapper(
    impl
  )
}
