package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.TableName
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateGlobalTableSettingsResponse(
    globalTableName: Optional[TableName] = Optional.Absent,
    replicaSettings: Optional[
      Iterable[zio.aws.dynamodb.model.ReplicaSettingsDescription]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.UpdateGlobalTableSettingsResponse = {
    import UpdateGlobalTableSettingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.UpdateGlobalTableSettingsResponse
      .builder()
      .optionallyWith(
        globalTableName.map(value => TableName.unwrap(value): java.lang.String)
      )(_.globalTableName)
      .optionallyWith(
        replicaSettings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.replicaSettings)
      .build()
  }
  def asReadOnly
      : zio.aws.dynamodb.model.UpdateGlobalTableSettingsResponse.ReadOnly =
    zio.aws.dynamodb.model.UpdateGlobalTableSettingsResponse
      .wrap(buildAwsValue())
}
object UpdateGlobalTableSettingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.UpdateGlobalTableSettingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.UpdateGlobalTableSettingsResponse =
      zio.aws.dynamodb.model.UpdateGlobalTableSettingsResponse(
        globalTableName.map(value => value),
        replicaSettings.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def globalTableName: Optional[TableName]
    def replicaSettings: Optional[
      List[zio.aws.dynamodb.model.ReplicaSettingsDescription.ReadOnly]
    ]
    def getGlobalTableName: ZIO[Any, AwsError, TableName] =
      AwsError.unwrapOptionField("globalTableName", globalTableName)
    def getReplicaSettings: ZIO[Any, AwsError, List[
      zio.aws.dynamodb.model.ReplicaSettingsDescription.ReadOnly
    ]] = AwsError.unwrapOptionField("replicaSettings", replicaSettings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.UpdateGlobalTableSettingsResponse
  ) extends zio.aws.dynamodb.model.UpdateGlobalTableSettingsResponse.ReadOnly {
    override val globalTableName: Optional[TableName] = zio.aws.core.internal
      .optionalFromNullable(impl.globalTableName())
      .map(value => zio.aws.dynamodb.model.primitives.TableName(value))
    override val replicaSettings: Optional[
      List[zio.aws.dynamodb.model.ReplicaSettingsDescription.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.replicaSettings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.dynamodb.model.ReplicaSettingsDescription.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.UpdateGlobalTableSettingsResponse
  ): zio.aws.dynamodb.model.UpdateGlobalTableSettingsResponse.ReadOnly =
    new Wrapper(impl)
}
