package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateKinesisStreamingConfiguration(
    approximateCreationDateTimePrecision: Optional[
      zio.aws.dynamodb.model.ApproximateCreationDateTimePrecision
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.UpdateKinesisStreamingConfiguration = {
    import UpdateKinesisStreamingConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.UpdateKinesisStreamingConfiguration
      .builder()
      .optionallyWith(
        approximateCreationDateTimePrecision.map(value => value.unwrap)
      )(_.approximateCreationDateTimePrecision)
      .build()
  }
  def asReadOnly
      : zio.aws.dynamodb.model.UpdateKinesisStreamingConfiguration.ReadOnly =
    zio.aws.dynamodb.model.UpdateKinesisStreamingConfiguration
      .wrap(buildAwsValue())
}
object UpdateKinesisStreamingConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.UpdateKinesisStreamingConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.UpdateKinesisStreamingConfiguration =
      zio.aws.dynamodb.model.UpdateKinesisStreamingConfiguration(
        approximateCreationDateTimePrecision.map(value => value)
      )
    def approximateCreationDateTimePrecision
        : Optional[zio.aws.dynamodb.model.ApproximateCreationDateTimePrecision]
    def getApproximateCreationDateTimePrecision: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.ApproximateCreationDateTimePrecision
    ] = AwsError.unwrapOptionField(
      "approximateCreationDateTimePrecision",
      approximateCreationDateTimePrecision
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.UpdateKinesisStreamingConfiguration
  ) extends zio.aws.dynamodb.model.UpdateKinesisStreamingConfiguration.ReadOnly {
    override val approximateCreationDateTimePrecision: Optional[
      zio.aws.dynamodb.model.ApproximateCreationDateTimePrecision
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.approximateCreationDateTimePrecision())
      .map(value =>
        zio.aws.dynamodb.model.ApproximateCreationDateTimePrecision.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.UpdateKinesisStreamingConfiguration
  ): zio.aws.dynamodb.model.UpdateKinesisStreamingConfiguration.ReadOnly =
    new Wrapper(impl)
}
