package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.{StreamArn, TableArn}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateKinesisStreamingDestinationRequest(
    tableName: TableArn,
    streamArn: StreamArn,
    updateKinesisStreamingConfiguration: Optional[
      zio.aws.dynamodb.model.UpdateKinesisStreamingConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.UpdateKinesisStreamingDestinationRequest = {
    import UpdateKinesisStreamingDestinationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.UpdateKinesisStreamingDestinationRequest
      .builder()
      .tableName(TableArn.unwrap(tableName): java.lang.String)
      .streamArn(StreamArn.unwrap(streamArn): java.lang.String)
      .optionallyWith(
        updateKinesisStreamingConfiguration.map(value => value.buildAwsValue())
      )(_.updateKinesisStreamingConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.dynamodb.model.UpdateKinesisStreamingDestinationRequest.ReadOnly =
    zio.aws.dynamodb.model.UpdateKinesisStreamingDestinationRequest
      .wrap(buildAwsValue())
}
object UpdateKinesisStreamingDestinationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.UpdateKinesisStreamingDestinationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.dynamodb.model.UpdateKinesisStreamingDestinationRequest =
      zio.aws.dynamodb.model.UpdateKinesisStreamingDestinationRequest(
        tableName,
        streamArn,
        updateKinesisStreamingConfiguration.map(value => value.asEditable)
      )
    def tableName: TableArn
    def streamArn: StreamArn
    def updateKinesisStreamingConfiguration: Optional[
      zio.aws.dynamodb.model.UpdateKinesisStreamingConfiguration.ReadOnly
    ]
    def getTableName: ZIO[Any, Nothing, TableArn] = ZIO.succeed(tableName)
    def getStreamArn: ZIO[Any, Nothing, StreamArn] = ZIO.succeed(streamArn)
    def getUpdateKinesisStreamingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.UpdateKinesisStreamingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "updateKinesisStreamingConfiguration",
      updateKinesisStreamingConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.UpdateKinesisStreamingDestinationRequest
  ) extends zio.aws.dynamodb.model.UpdateKinesisStreamingDestinationRequest.ReadOnly {
    override val tableName: TableArn =
      zio.aws.dynamodb.model.primitives.TableArn(impl.tableName())
    override val streamArn: StreamArn =
      zio.aws.dynamodb.model.primitives.StreamArn(impl.streamArn())
    override val updateKinesisStreamingConfiguration: Optional[
      zio.aws.dynamodb.model.UpdateKinesisStreamingConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.updateKinesisStreamingConfiguration())
      .map(value =>
        zio.aws.dynamodb.model.UpdateKinesisStreamingConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.UpdateKinesisStreamingDestinationRequest
  ): zio.aws.dynamodb.model.UpdateKinesisStreamingDestinationRequest.ReadOnly =
    new Wrapper(impl)
}
