package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.{StreamArn, TableName}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateKinesisStreamingDestinationResponse(
    tableName: Optional[TableName] = Optional.Absent,
    streamArn: Optional[StreamArn] = Optional.Absent,
    destinationStatus: Optional[zio.aws.dynamodb.model.DestinationStatus] =
      Optional.Absent,
    updateKinesisStreamingConfiguration: Optional[
      zio.aws.dynamodb.model.UpdateKinesisStreamingConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.UpdateKinesisStreamingDestinationResponse = {
    import UpdateKinesisStreamingDestinationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.UpdateKinesisStreamingDestinationResponse
      .builder()
      .optionallyWith(
        tableName.map(value => TableName.unwrap(value): java.lang.String)
      )(_.tableName)
      .optionallyWith(
        streamArn.map(value => StreamArn.unwrap(value): java.lang.String)
      )(_.streamArn)
      .optionallyWith(destinationStatus.map(value => value.unwrap))(
        _.destinationStatus
      )
      .optionallyWith(
        updateKinesisStreamingConfiguration.map(value => value.buildAwsValue())
      )(_.updateKinesisStreamingConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.dynamodb.model.UpdateKinesisStreamingDestinationResponse.ReadOnly =
    zio.aws.dynamodb.model.UpdateKinesisStreamingDestinationResponse
      .wrap(buildAwsValue())
}
object UpdateKinesisStreamingDestinationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.UpdateKinesisStreamingDestinationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.dynamodb.model.UpdateKinesisStreamingDestinationResponse =
      zio.aws.dynamodb.model.UpdateKinesisStreamingDestinationResponse(
        tableName.map(value => value),
        streamArn.map(value => value),
        destinationStatus.map(value => value),
        updateKinesisStreamingConfiguration.map(value => value.asEditable)
      )
    def tableName: Optional[TableName]
    def streamArn: Optional[StreamArn]
    def destinationStatus: Optional[zio.aws.dynamodb.model.DestinationStatus]
    def updateKinesisStreamingConfiguration: Optional[
      zio.aws.dynamodb.model.UpdateKinesisStreamingConfiguration.ReadOnly
    ]
    def getTableName: ZIO[Any, AwsError, TableName] =
      AwsError.unwrapOptionField("tableName", tableName)
    def getStreamArn: ZIO[Any, AwsError, StreamArn] =
      AwsError.unwrapOptionField("streamArn", streamArn)
    def getDestinationStatus
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.DestinationStatus] =
      AwsError.unwrapOptionField("destinationStatus", destinationStatus)
    def getUpdateKinesisStreamingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.UpdateKinesisStreamingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "updateKinesisStreamingConfiguration",
      updateKinesisStreamingConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.UpdateKinesisStreamingDestinationResponse
  ) extends zio.aws.dynamodb.model.UpdateKinesisStreamingDestinationResponse.ReadOnly {
    override val tableName: Optional[TableName] = zio.aws.core.internal
      .optionalFromNullable(impl.tableName())
      .map(value => zio.aws.dynamodb.model.primitives.TableName(value))
    override val streamArn: Optional[StreamArn] = zio.aws.core.internal
      .optionalFromNullable(impl.streamArn())
      .map(value => zio.aws.dynamodb.model.primitives.StreamArn(value))
    override val destinationStatus
        : Optional[zio.aws.dynamodb.model.DestinationStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationStatus())
        .map(value => zio.aws.dynamodb.model.DestinationStatus.wrap(value))
    override val updateKinesisStreamingConfiguration: Optional[
      zio.aws.dynamodb.model.UpdateKinesisStreamingConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.updateKinesisStreamingConfiguration())
      .map(value =>
        zio.aws.dynamodb.model.UpdateKinesisStreamingConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.UpdateKinesisStreamingDestinationResponse
  ): zio.aws.dynamodb.model.UpdateKinesisStreamingDestinationResponse.ReadOnly =
    new Wrapper(impl)
}
