package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.{KMSMasterKeyId, RegionName}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateReplicationGroupMemberAction(
    regionName: RegionName,
    kmsMasterKeyId: Optional[KMSMasterKeyId] = Optional.Absent,
    provisionedThroughputOverride: Optional[
      zio.aws.dynamodb.model.ProvisionedThroughputOverride
    ] = Optional.Absent,
    onDemandThroughputOverride: Optional[
      zio.aws.dynamodb.model.OnDemandThroughputOverride
    ] = Optional.Absent,
    globalSecondaryIndexes: Optional[
      Iterable[zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndex]
    ] = Optional.Absent,
    tableClassOverride: Optional[zio.aws.dynamodb.model.TableClass] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.UpdateReplicationGroupMemberAction = {
    import UpdateReplicationGroupMemberAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.UpdateReplicationGroupMemberAction
      .builder()
      .regionName(RegionName.unwrap(regionName): java.lang.String)
      .optionallyWith(
        kmsMasterKeyId.map(value =>
          KMSMasterKeyId.unwrap(value): java.lang.String
        )
      )(_.kmsMasterKeyId)
      .optionallyWith(
        provisionedThroughputOverride.map(value => value.buildAwsValue())
      )(_.provisionedThroughputOverride)
      .optionallyWith(
        onDemandThroughputOverride.map(value => value.buildAwsValue())
      )(_.onDemandThroughputOverride)
      .optionallyWith(
        globalSecondaryIndexes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.globalSecondaryIndexes)
      .optionallyWith(tableClassOverride.map(value => value.unwrap))(
        _.tableClassOverride
      )
      .build()
  }
  def asReadOnly
      : zio.aws.dynamodb.model.UpdateReplicationGroupMemberAction.ReadOnly =
    zio.aws.dynamodb.model.UpdateReplicationGroupMemberAction
      .wrap(buildAwsValue())
}
object UpdateReplicationGroupMemberAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.UpdateReplicationGroupMemberAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.UpdateReplicationGroupMemberAction =
      zio.aws.dynamodb.model.UpdateReplicationGroupMemberAction(
        regionName,
        kmsMasterKeyId.map(value => value),
        provisionedThroughputOverride.map(value => value.asEditable),
        onDemandThroughputOverride.map(value => value.asEditable),
        globalSecondaryIndexes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tableClassOverride.map(value => value)
      )
    def regionName: RegionName
    def kmsMasterKeyId: Optional[KMSMasterKeyId]
    def provisionedThroughputOverride: Optional[
      zio.aws.dynamodb.model.ProvisionedThroughputOverride.ReadOnly
    ]
    def onDemandThroughputOverride
        : Optional[zio.aws.dynamodb.model.OnDemandThroughputOverride.ReadOnly]
    def globalSecondaryIndexes: Optional[
      List[zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndex.ReadOnly]
    ]
    def tableClassOverride: Optional[zio.aws.dynamodb.model.TableClass]
    def getRegionName: ZIO[Any, Nothing, RegionName] = ZIO.succeed(regionName)
    def getKmsMasterKeyId: ZIO[Any, AwsError, KMSMasterKeyId] =
      AwsError.unwrapOptionField("kmsMasterKeyId", kmsMasterKeyId)
    def getProvisionedThroughputOverride: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.ProvisionedThroughputOverride.ReadOnly
    ] = AwsError.unwrapOptionField(
      "provisionedThroughputOverride",
      provisionedThroughputOverride
    )
    def getOnDemandThroughputOverride: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.OnDemandThroughputOverride.ReadOnly
    ] = AwsError.unwrapOptionField(
      "onDemandThroughputOverride",
      onDemandThroughputOverride
    )
    def getGlobalSecondaryIndexes: ZIO[Any, AwsError, List[
      zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndex.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "globalSecondaryIndexes",
      globalSecondaryIndexes
    )
    def getTableClassOverride
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.TableClass] =
      AwsError.unwrapOptionField("tableClassOverride", tableClassOverride)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.UpdateReplicationGroupMemberAction
  ) extends zio.aws.dynamodb.model.UpdateReplicationGroupMemberAction.ReadOnly {
    override val regionName: RegionName =
      zio.aws.dynamodb.model.primitives.RegionName(impl.regionName())
    override val kmsMasterKeyId: Optional[KMSMasterKeyId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.kmsMasterKeyId())
        .map(value => zio.aws.dynamodb.model.primitives.KMSMasterKeyId(value))
    override val provisionedThroughputOverride: Optional[
      zio.aws.dynamodb.model.ProvisionedThroughputOverride.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.provisionedThroughputOverride())
      .map(value =>
        zio.aws.dynamodb.model.ProvisionedThroughputOverride.wrap(value)
      )
    override val onDemandThroughputOverride
        : Optional[zio.aws.dynamodb.model.OnDemandThroughputOverride.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.onDemandThroughputOverride())
        .map(value =>
          zio.aws.dynamodb.model.OnDemandThroughputOverride.wrap(value)
        )
    override val globalSecondaryIndexes: Optional[
      List[zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndex.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.globalSecondaryIndexes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndex.wrap(item)
        }.toList
      )
    override val tableClassOverride
        : Optional[zio.aws.dynamodb.model.TableClass] = zio.aws.core.internal
      .optionalFromNullable(impl.tableClassOverride())
      .map(value => zio.aws.dynamodb.model.TableClass.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.UpdateReplicationGroupMemberAction
  ): zio.aws.dynamodb.model.UpdateReplicationGroupMemberAction.ReadOnly =
    new Wrapper(impl)
}
