package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateTimeToLiveResponse(
    timeToLiveSpecification: Optional[
      zio.aws.dynamodb.model.TimeToLiveSpecification
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.UpdateTimeToLiveResponse = {
    import UpdateTimeToLiveResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.UpdateTimeToLiveResponse
      .builder()
      .optionallyWith(
        timeToLiveSpecification.map(value => value.buildAwsValue())
      )(_.timeToLiveSpecification)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.UpdateTimeToLiveResponse.ReadOnly =
    zio.aws.dynamodb.model.UpdateTimeToLiveResponse.wrap(buildAwsValue())
}
object UpdateTimeToLiveResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.UpdateTimeToLiveResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.UpdateTimeToLiveResponse =
      zio.aws.dynamodb.model.UpdateTimeToLiveResponse(
        timeToLiveSpecification.map(value => value.asEditable)
      )
    def timeToLiveSpecification
        : Optional[zio.aws.dynamodb.model.TimeToLiveSpecification.ReadOnly]
    def getTimeToLiveSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.TimeToLiveSpecification.ReadOnly
    ] = AwsError.unwrapOptionField(
      "timeToLiveSpecification",
      timeToLiveSpecification
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.UpdateTimeToLiveResponse
  ) extends zio.aws.dynamodb.model.UpdateTimeToLiveResponse.ReadOnly {
    override val timeToLiveSpecification
        : Optional[zio.aws.dynamodb.model.TimeToLiveSpecification.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timeToLiveSpecification())
        .map(value =>
          zio.aws.dynamodb.model.TimeToLiveSpecification.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.UpdateTimeToLiveResponse
  ): zio.aws.dynamodb.model.UpdateTimeToLiveResponse.ReadOnly = new Wrapper(
    impl
  )
}
