package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.LongObject
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class WarmThroughput(
    readUnitsPerSecond: Optional[LongObject] = Optional.Absent,
    writeUnitsPerSecond: Optional[LongObject] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.WarmThroughput = {
    import WarmThroughput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.WarmThroughput
      .builder()
      .optionallyWith(readUnitsPerSecond.map(value => value: java.lang.Long))(
        _.readUnitsPerSecond
      )
      .optionallyWith(writeUnitsPerSecond.map(value => value: java.lang.Long))(
        _.writeUnitsPerSecond
      )
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.WarmThroughput.ReadOnly =
    zio.aws.dynamodb.model.WarmThroughput.wrap(buildAwsValue())
}
object WarmThroughput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.WarmThroughput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.WarmThroughput =
      zio.aws.dynamodb.model.WarmThroughput(
        readUnitsPerSecond.map(value => value),
        writeUnitsPerSecond.map(value => value)
      )
    def readUnitsPerSecond: Optional[LongObject]
    def writeUnitsPerSecond: Optional[LongObject]
    def getReadUnitsPerSecond: ZIO[Any, AwsError, LongObject] =
      AwsError.unwrapOptionField("readUnitsPerSecond", readUnitsPerSecond)
    def getWriteUnitsPerSecond: ZIO[Any, AwsError, LongObject] =
      AwsError.unwrapOptionField("writeUnitsPerSecond", writeUnitsPerSecond)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.WarmThroughput
  ) extends zio.aws.dynamodb.model.WarmThroughput.ReadOnly {
    override val readUnitsPerSecond: Optional[LongObject] =
      zio.aws.core.internal
        .optionalFromNullable(impl.readUnitsPerSecond())
        .map(value => value: LongObject)
    override val writeUnitsPerSecond: Optional[LongObject] =
      zio.aws.core.internal
        .optionalFromNullable(impl.writeUnitsPerSecond())
        .map(value => value: LongObject)
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.WarmThroughput
  ): zio.aws.dynamodb.model.WarmThroughput.ReadOnly = new Wrapper(impl)
}
