package zio.aws.dynamodb
import zio.aws.dynamodb.model.primitives.ExportToTime.Type
import java.time.Instant
import zio.aws.dynamodb.model.primitives.{
  IndexName,
  TableName,
  AttributeName,
  ItemCollectionSizeEstimateBound,
  ContributorInsightsRule,
  ExpressionAttributeNameVariable,
  StringAttributeValue,
  NumberAttributeValue,
  NonKeyAttributeName,
  ExpressionAttributeValueVariable,
  CsvHeader,
  TagKeyString,
  TableArn,
  BinaryAttributeValue
}
import zio.Chunk
import zio.prelude.Subtype
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    object ArchivalReason extends zio.prelude.Subtype[String]
    type ArchivalReason = zio.aws.dynamodb.model.primitives.ArchivalReason.Type
    object AttributeName extends zio.prelude.Subtype[String]
    type AttributeName = zio.aws.dynamodb.model.primitives.AttributeName.Type
    object AutoScalingPolicyName extends zio.prelude.Subtype[String]
    type AutoScalingPolicyName =
      zio.aws.dynamodb.model.primitives.AutoScalingPolicyName.Type
    object AutoScalingRoleArn extends zio.prelude.Subtype[String]
    type AutoScalingRoleArn =
      zio.aws.dynamodb.model.primitives.AutoScalingRoleArn.Type
    object Backfilling extends zio.prelude.Subtype[Boolean]
    type Backfilling = zio.aws.dynamodb.model.primitives.Backfilling.Type
    object BackupArn extends zio.prelude.Subtype[String]
    type BackupArn = zio.aws.dynamodb.model.primitives.BackupArn.Type
    object BackupCreationDateTime extends zio.prelude.Subtype[Instant]
    type BackupCreationDateTime =
      zio.aws.dynamodb.model.primitives.BackupCreationDateTime.Type
    object BackupName extends zio.prelude.Subtype[String]
    type BackupName = zio.aws.dynamodb.model.primitives.BackupName.Type
    object BackupSizeBytes extends zio.prelude.Subtype[Long]
    type BackupSizeBytes =
      zio.aws.dynamodb.model.primitives.BackupSizeBytes.Type
    object BackupsInputLimit extends zio.prelude.Subtype[Int]
    type BackupsInputLimit =
      zio.aws.dynamodb.model.primitives.BackupsInputLimit.Type
    object BilledSizeBytes extends zio.prelude.Subtype[Long]
    type BilledSizeBytes =
      zio.aws.dynamodb.model.primitives.BilledSizeBytes.Type
    object BinaryAttributeValue extends zio.prelude.Subtype[Chunk[Byte]]
    type BinaryAttributeValue =
      zio.aws.dynamodb.model.primitives.BinaryAttributeValue.Type
    object BooleanAttributeValue extends zio.prelude.Subtype[Boolean]
    type BooleanAttributeValue =
      zio.aws.dynamodb.model.primitives.BooleanAttributeValue.Type
    type BooleanObject = Boolean
    object ClientRequestToken extends zio.prelude.Subtype[String]
    type ClientRequestToken =
      zio.aws.dynamodb.model.primitives.ClientRequestToken.Type
    object ClientToken extends zio.prelude.Subtype[String]
    type ClientToken = zio.aws.dynamodb.model.primitives.ClientToken.Type
    object CloudWatchLogGroupArn extends zio.prelude.Subtype[String]
    type CloudWatchLogGroupArn =
      zio.aws.dynamodb.model.primitives.CloudWatchLogGroupArn.Type
    object ConditionExpression extends zio.prelude.Subtype[String]
    type ConditionExpression =
      zio.aws.dynamodb.model.primitives.ConditionExpression.Type
    object ConfirmRemoveSelfResourceAccess extends zio.prelude.Subtype[Boolean]
    type ConfirmRemoveSelfResourceAccess =
      zio.aws.dynamodb.model.primitives.ConfirmRemoveSelfResourceAccess.Type
    object ConsistentRead extends zio.prelude.Subtype[Boolean]
    type ConsistentRead = zio.aws.dynamodb.model.primitives.ConsistentRead.Type
    object ConsumedCapacityUnits extends zio.prelude.Subtype[Double]
    type ConsumedCapacityUnits =
      zio.aws.dynamodb.model.primitives.ConsumedCapacityUnits.Type
    object ContributorInsightsRule extends zio.prelude.Subtype[String]
    type ContributorInsightsRule =
      zio.aws.dynamodb.model.primitives.ContributorInsightsRule.Type
    object CsvDelimiter extends zio.prelude.Subtype[String]
    type CsvDelimiter = zio.aws.dynamodb.model.primitives.CsvDelimiter.Type
    object CsvHeader extends zio.prelude.Subtype[String]
    type CsvHeader = zio.aws.dynamodb.model.primitives.CsvHeader.Type
    object Date extends zio.prelude.Subtype[Instant]
    type Date = zio.aws.dynamodb.model.primitives.Date.Type
    object DeletionProtectionEnabled extends zio.prelude.Subtype[Boolean]
    type DeletionProtectionEnabled =
      zio.aws.dynamodb.model.primitives.DeletionProtectionEnabled.Type
    type DoubleObject = Double
    object ErrorCount extends zio.prelude.Subtype[Long]
    type ErrorCount = zio.aws.dynamodb.model.primitives.ErrorCount.Type
    object ExceptionDescription extends zio.prelude.Subtype[String]
    type ExceptionDescription =
      zio.aws.dynamodb.model.primitives.ExceptionDescription.Type
    object ExceptionName extends zio.prelude.Subtype[String]
    type ExceptionName = zio.aws.dynamodb.model.primitives.ExceptionName.Type
    object ExportArn extends zio.prelude.Subtype[String]
    type ExportArn = zio.aws.dynamodb.model.primitives.ExportArn.Type
    object ExportEndTime extends zio.prelude.Subtype[Instant]
    type ExportEndTime = zio.aws.dynamodb.model.primitives.ExportEndTime.Type
    object ExportFromTime extends zio.prelude.Subtype[Instant]
    type ExportFromTime = zio.aws.dynamodb.model.primitives.ExportFromTime.Type
    object ExportManifest extends zio.prelude.Subtype[String]
    type ExportManifest = zio.aws.dynamodb.model.primitives.ExportManifest.Type
    object ExportNextToken extends zio.prelude.Subtype[String]
    type ExportNextToken =
      zio.aws.dynamodb.model.primitives.ExportNextToken.Type
    object ExportStartTime extends zio.prelude.Subtype[Instant]
    type ExportStartTime =
      zio.aws.dynamodb.model.primitives.ExportStartTime.Type
    object ExportTime extends zio.prelude.Subtype[Instant]
    type ExportTime = zio.aws.dynamodb.model.primitives.ExportTime.Type
    object ExportToTime extends zio.prelude.Subtype[Instant]
    type ExportToTime = zio.aws.dynamodb.model.primitives.ExportToTime.Type
    object ExpressionAttributeNameVariable extends zio.prelude.Subtype[String]
    type ExpressionAttributeNameVariable =
      zio.aws.dynamodb.model.primitives.ExpressionAttributeNameVariable.Type
    object ExpressionAttributeValueVariable extends zio.prelude.Subtype[String]
    type ExpressionAttributeValueVariable =
      zio.aws.dynamodb.model.primitives.ExpressionAttributeValueVariable.Type
    object FailureCode extends zio.prelude.Subtype[String]
    type FailureCode = zio.aws.dynamodb.model.primitives.FailureCode.Type
    object FailureMessage extends zio.prelude.Subtype[String]
    type FailureMessage = zio.aws.dynamodb.model.primitives.FailureMessage.Type
    object GlobalTableArnString extends zio.prelude.Subtype[String]
    type GlobalTableArnString =
      zio.aws.dynamodb.model.primitives.GlobalTableArnString.Type
    object ImportArn extends zio.prelude.Subtype[String]
    type ImportArn = zio.aws.dynamodb.model.primitives.ImportArn.Type
    object ImportEndTime extends zio.prelude.Subtype[Instant]
    type ImportEndTime = zio.aws.dynamodb.model.primitives.ImportEndTime.Type
    object ImportNextToken extends zio.prelude.Subtype[String]
    type ImportNextToken =
      zio.aws.dynamodb.model.primitives.ImportNextToken.Type
    object ImportStartTime extends zio.prelude.Subtype[Instant]
    type ImportStartTime =
      zio.aws.dynamodb.model.primitives.ImportStartTime.Type
    object ImportedItemCount extends zio.prelude.Subtype[Long]
    type ImportedItemCount =
      zio.aws.dynamodb.model.primitives.ImportedItemCount.Type
    object IndexName extends zio.prelude.Subtype[String]
    type IndexName = zio.aws.dynamodb.model.primitives.IndexName.Type
    type Integer = Int
    type IntegerObject = Int
    object ItemCollectionSizeEstimateBound extends zio.prelude.Subtype[Double]
    type ItemCollectionSizeEstimateBound =
      zio.aws.dynamodb.model.primitives.ItemCollectionSizeEstimateBound.Type
    object ItemCount extends zio.prelude.Subtype[Long]
    type ItemCount = zio.aws.dynamodb.model.primitives.ItemCount.Type
    object KMSMasterKeyArn extends zio.prelude.Subtype[String]
    type KMSMasterKeyArn =
      zio.aws.dynamodb.model.primitives.KMSMasterKeyArn.Type
    object KMSMasterKeyId extends zio.prelude.Subtype[String]
    type KMSMasterKeyId = zio.aws.dynamodb.model.primitives.KMSMasterKeyId.Type
    object KeyExpression extends zio.prelude.Subtype[String]
    type KeyExpression = zio.aws.dynamodb.model.primitives.KeyExpression.Type
    object KeySchemaAttributeName extends zio.prelude.Subtype[String]
    type KeySchemaAttributeName =
      zio.aws.dynamodb.model.primitives.KeySchemaAttributeName.Type
    object LastUpdateDateTime extends zio.prelude.Subtype[Instant]
    type LastUpdateDateTime =
      zio.aws.dynamodb.model.primitives.LastUpdateDateTime.Type
    object ListContributorInsightsLimit extends zio.prelude.Subtype[Int]
    type ListContributorInsightsLimit =
      zio.aws.dynamodb.model.primitives.ListContributorInsightsLimit.Type
    object ListExportsMaxLimit extends zio.prelude.Subtype[Int]
    type ListExportsMaxLimit =
      zio.aws.dynamodb.model.primitives.ListExportsMaxLimit.Type
    object ListImportsMaxLimit extends zio.prelude.Subtype[Int]
    type ListImportsMaxLimit =
      zio.aws.dynamodb.model.primitives.ListImportsMaxLimit.Type
    object ListTablesInputLimit extends zio.prelude.Subtype[Int]
    type ListTablesInputLimit =
      zio.aws.dynamodb.model.primitives.ListTablesInputLimit.Type
    type LongObject = Long
    object NextTokenString extends zio.prelude.Subtype[String]
    type NextTokenString =
      zio.aws.dynamodb.model.primitives.NextTokenString.Type
    object NonKeyAttributeName extends zio.prelude.Subtype[String]
    type NonKeyAttributeName =
      zio.aws.dynamodb.model.primitives.NonKeyAttributeName.Type
    object NonNegativeLongObject extends zio.prelude.Subtype[Long]
    type NonNegativeLongObject =
      zio.aws.dynamodb.model.primitives.NonNegativeLongObject.Type
    object NullAttributeValue extends zio.prelude.Subtype[Boolean]
    type NullAttributeValue =
      zio.aws.dynamodb.model.primitives.NullAttributeValue.Type
    object NumberAttributeValue extends zio.prelude.Subtype[String]
    type NumberAttributeValue =
      zio.aws.dynamodb.model.primitives.NumberAttributeValue.Type
    object PartiQLNextToken extends zio.prelude.Subtype[String]
    type PartiQLNextToken =
      zio.aws.dynamodb.model.primitives.PartiQLNextToken.Type
    object PartiQLStatement extends zio.prelude.Subtype[String]
    type PartiQLStatement =
      zio.aws.dynamodb.model.primitives.PartiQLStatement.Type
    object PolicyRevisionId extends zio.prelude.Subtype[String]
    type PolicyRevisionId =
      zio.aws.dynamodb.model.primitives.PolicyRevisionId.Type
    object PositiveIntegerObject extends zio.prelude.Subtype[Int]
    type PositiveIntegerObject =
      zio.aws.dynamodb.model.primitives.PositiveIntegerObject.Type
    object PositiveLongObject extends zio.prelude.Subtype[Long]
    type PositiveLongObject =
      zio.aws.dynamodb.model.primitives.PositiveLongObject.Type
    object ProcessedItemCount extends zio.prelude.Subtype[Long]
    type ProcessedItemCount =
      zio.aws.dynamodb.model.primitives.ProcessedItemCount.Type
    object ProjectionExpression extends zio.prelude.Subtype[String]
    type ProjectionExpression =
      zio.aws.dynamodb.model.primitives.ProjectionExpression.Type
    object RecoveryPeriodInDays extends zio.prelude.Subtype[Int]
    type RecoveryPeriodInDays =
      zio.aws.dynamodb.model.primitives.RecoveryPeriodInDays.Type
    object RegionName extends zio.prelude.Subtype[String]
    type RegionName = zio.aws.dynamodb.model.primitives.RegionName.Type
    object ReplicaStatusDescription extends zio.prelude.Subtype[String]
    type ReplicaStatusDescription =
      zio.aws.dynamodb.model.primitives.ReplicaStatusDescription.Type
    object ReplicaStatusPercentProgress extends zio.prelude.Subtype[String]
    type ReplicaStatusPercentProgress =
      zio.aws.dynamodb.model.primitives.ReplicaStatusPercentProgress.Type
    object ResourceArnString extends zio.prelude.Subtype[String]
    type ResourceArnString =
      zio.aws.dynamodb.model.primitives.ResourceArnString.Type
    object ResourcePolicy extends zio.prelude.Subtype[String]
    type ResourcePolicy = zio.aws.dynamodb.model.primitives.ResourcePolicy.Type
    object RestoreInProgress extends zio.prelude.Subtype[Boolean]
    type RestoreInProgress =
      zio.aws.dynamodb.model.primitives.RestoreInProgress.Type
    object S3Bucket extends zio.prelude.Subtype[String]
    type S3Bucket = zio.aws.dynamodb.model.primitives.S3Bucket.Type
    object S3BucketOwner extends zio.prelude.Subtype[String]
    type S3BucketOwner = zio.aws.dynamodb.model.primitives.S3BucketOwner.Type
    object S3Prefix extends zio.prelude.Subtype[String]
    type S3Prefix = zio.aws.dynamodb.model.primitives.S3Prefix.Type
    object S3SseKmsKeyId extends zio.prelude.Subtype[String]
    type S3SseKmsKeyId = zio.aws.dynamodb.model.primitives.S3SseKmsKeyId.Type
    object SSEEnabled extends zio.prelude.Subtype[Boolean]
    type SSEEnabled = zio.aws.dynamodb.model.primitives.SSEEnabled.Type
    object ScanSegment extends zio.prelude.Subtype[Int]
    type ScanSegment = zio.aws.dynamodb.model.primitives.ScanSegment.Type
    object ScanTotalSegments extends zio.prelude.Subtype[Int]
    type ScanTotalSegments =
      zio.aws.dynamodb.model.primitives.ScanTotalSegments.Type
    object StreamArn extends zio.prelude.Subtype[String]
    type StreamArn = zio.aws.dynamodb.model.primitives.StreamArn.Type
    object StreamEnabled extends zio.prelude.Subtype[Boolean]
    type StreamEnabled = zio.aws.dynamodb.model.primitives.StreamEnabled.Type
    object StringAttributeValue extends zio.prelude.Subtype[String]
    type StringAttributeValue =
      zio.aws.dynamodb.model.primitives.StringAttributeValue.Type
    object TableArn extends zio.prelude.Subtype[String]
    type TableArn = zio.aws.dynamodb.model.primitives.TableArn.Type
    object TableCreationDateTime extends zio.prelude.Subtype[Instant]
    type TableCreationDateTime =
      zio.aws.dynamodb.model.primitives.TableCreationDateTime.Type
    object TableId extends zio.prelude.Subtype[String]
    type TableId = zio.aws.dynamodb.model.primitives.TableId.Type
    object TableName extends zio.prelude.Subtype[String]
    type TableName = zio.aws.dynamodb.model.primitives.TableName.Type
    object TagKeyString extends zio.prelude.Subtype[String]
    type TagKeyString = zio.aws.dynamodb.model.primitives.TagKeyString.Type
    object TagValueString extends zio.prelude.Subtype[String]
    type TagValueString = zio.aws.dynamodb.model.primitives.TagValueString.Type
    object TimeRangeLowerBound extends zio.prelude.Subtype[Instant]
    type TimeRangeLowerBound =
      zio.aws.dynamodb.model.primitives.TimeRangeLowerBound.Type
    object TimeRangeUpperBound extends zio.prelude.Subtype[Instant]
    type TimeRangeUpperBound =
      zio.aws.dynamodb.model.primitives.TimeRangeUpperBound.Type
    object TimeToLiveAttributeName extends zio.prelude.Subtype[String]
    type TimeToLiveAttributeName =
      zio.aws.dynamodb.model.primitives.TimeToLiveAttributeName.Type
    object TimeToLiveEnabled extends zio.prelude.Subtype[Boolean]
    type TimeToLiveEnabled =
      zio.aws.dynamodb.model.primitives.TimeToLiveEnabled.Type
    object UpdateExpression extends zio.prelude.Subtype[String]
    type UpdateExpression =
      zio.aws.dynamodb.model.primitives.UpdateExpression.Type
  }
  type AttributeDefinitions = List[zio.aws.dynamodb.model.AttributeDefinition]
  type AttributeMap = Map[AttributeName, zio.aws.dynamodb.model.AttributeValue]
  type AttributeNameList = List[AttributeName]
  type AttributeUpdates =
    Map[AttributeName, zio.aws.dynamodb.model.AttributeValueUpdate]
  type AttributeValueList = List[zio.aws.dynamodb.model.AttributeValue]
  type AutoScalingPolicyDescriptionList =
    List[zio.aws.dynamodb.model.AutoScalingPolicyDescription]
  type BackupSummaries = List[zio.aws.dynamodb.model.BackupSummary]
  type BatchGetRequestMap =
    Map[TableArn, zio.aws.dynamodb.model.KeysAndAttributes]
  type BatchGetResponseMap = Map[TableArn, Iterable[
    Map[AttributeName, zio.aws.dynamodb.model.AttributeValue]
  ]]
  type BatchWriteItemRequestMap =
    Map[TableArn, Iterable[zio.aws.dynamodb.model.WriteRequest]]
  type BinarySetAttributeValue = List[BinaryAttributeValue]
  type ConsumedCapacityMultiple = List[zio.aws.dynamodb.model.ConsumedCapacity]
  type ContributorInsightsRuleList = List[ContributorInsightsRule]
  type ContributorInsightsSummaries =
    List[zio.aws.dynamodb.model.ContributorInsightsSummary]
  type CsvHeaderList = List[CsvHeader]
  type Endpoints = List[zio.aws.dynamodb.model.Endpoint]
  type ExpectedAttributeMap =
    Map[AttributeName, zio.aws.dynamodb.model.ExpectedAttributeValue]
  type ExportSummaries = List[zio.aws.dynamodb.model.ExportSummary]
  type ExpressionAttributeNameMap =
    Map[ExpressionAttributeNameVariable, AttributeName]
  type ExpressionAttributeValueMap =
    Map[ExpressionAttributeValueVariable, zio.aws.dynamodb.model.AttributeValue]
  type FilterConditionMap = Map[AttributeName, zio.aws.dynamodb.model.Condition]
  type GlobalSecondaryIndexAutoScalingUpdateList =
    List[zio.aws.dynamodb.model.GlobalSecondaryIndexAutoScalingUpdate]
  type GlobalSecondaryIndexDescriptionList =
    List[zio.aws.dynamodb.model.GlobalSecondaryIndexDescription]
  type GlobalSecondaryIndexList =
    List[zio.aws.dynamodb.model.GlobalSecondaryIndex]
  type GlobalSecondaryIndexUpdateList =
    List[zio.aws.dynamodb.model.GlobalSecondaryIndexUpdate]
  type GlobalSecondaryIndexes =
    List[zio.aws.dynamodb.model.GlobalSecondaryIndexInfo]
  type GlobalTableGlobalSecondaryIndexSettingsUpdateList =
    List[zio.aws.dynamodb.model.GlobalTableGlobalSecondaryIndexSettingsUpdate]
  type GlobalTableList = List[zio.aws.dynamodb.model.GlobalTable]
  type ImportSummaryList = List[zio.aws.dynamodb.model.ImportSummary]
  type ItemCollectionKeyAttributeMap =
    Map[AttributeName, zio.aws.dynamodb.model.AttributeValue]
  type ItemCollectionMetricsMultiple =
    List[zio.aws.dynamodb.model.ItemCollectionMetrics]
  type ItemCollectionMetricsPerTable =
    Map[TableArn, Iterable[zio.aws.dynamodb.model.ItemCollectionMetrics]]
  type ItemCollectionSizeEstimateRange = List[ItemCollectionSizeEstimateBound]
  type ItemList =
    List[Map[AttributeName, zio.aws.dynamodb.model.AttributeValue]]
  type ItemResponseList = List[zio.aws.dynamodb.model.ItemResponse]
  type Key = Map[AttributeName, zio.aws.dynamodb.model.AttributeValue]
  type KeyConditions = Map[AttributeName, zio.aws.dynamodb.model.Condition]
  type KeyList = List[Map[AttributeName, zio.aws.dynamodb.model.AttributeValue]]
  type KeySchema = List[zio.aws.dynamodb.model.KeySchemaElement]
  type KinesisDataStreamDestinations =
    List[zio.aws.dynamodb.model.KinesisDataStreamDestination]
  type ListAttributeValue = List[zio.aws.dynamodb.model.AttributeValue]
  type LocalSecondaryIndexDescriptionList =
    List[zio.aws.dynamodb.model.LocalSecondaryIndexDescription]
  type LocalSecondaryIndexList =
    List[zio.aws.dynamodb.model.LocalSecondaryIndex]
  type LocalSecondaryIndexes =
    List[zio.aws.dynamodb.model.LocalSecondaryIndexInfo]
  type MapAttributeValue =
    Map[AttributeName, zio.aws.dynamodb.model.AttributeValue]
  type NonKeyAttributeNameList = List[NonKeyAttributeName]
  type NumberSetAttributeValue = List[NumberAttributeValue]
  type ParameterizedStatements =
    List[zio.aws.dynamodb.model.ParameterizedStatement]
  type PartiQLBatchRequest = List[zio.aws.dynamodb.model.BatchStatementRequest]
  type PartiQLBatchResponse =
    List[zio.aws.dynamodb.model.BatchStatementResponse]
  type PreparedStatementParameters = List[zio.aws.dynamodb.model.AttributeValue]
  type PutItemInputAttributeMap =
    Map[AttributeName, zio.aws.dynamodb.model.AttributeValue]
  type ReplicaAutoScalingDescriptionList =
    List[zio.aws.dynamodb.model.ReplicaAutoScalingDescription]
  type ReplicaAutoScalingUpdateList =
    List[zio.aws.dynamodb.model.ReplicaAutoScalingUpdate]
  type ReplicaDescriptionList = List[zio.aws.dynamodb.model.ReplicaDescription]
  type ReplicaGlobalSecondaryIndexAutoScalingDescriptionList = List[
    zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexAutoScalingDescription
  ]
  type ReplicaGlobalSecondaryIndexAutoScalingUpdateList =
    List[zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexAutoScalingUpdate]
  type ReplicaGlobalSecondaryIndexDescriptionList =
    List[zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexDescription]
  type ReplicaGlobalSecondaryIndexList =
    List[zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndex]
  type ReplicaGlobalSecondaryIndexSettingsDescriptionList =
    List[zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexSettingsDescription]
  type ReplicaGlobalSecondaryIndexSettingsUpdateList =
    List[zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexSettingsUpdate]
  type ReplicaList = List[zio.aws.dynamodb.model.Replica]
  type ReplicaSettingsDescriptionList =
    List[zio.aws.dynamodb.model.ReplicaSettingsDescription]
  type ReplicaSettingsUpdateList =
    List[zio.aws.dynamodb.model.ReplicaSettingsUpdate]
  type ReplicaUpdateList = List[zio.aws.dynamodb.model.ReplicaUpdate]
  type ReplicationGroupUpdateList =
    List[zio.aws.dynamodb.model.ReplicationGroupUpdate]
  type SecondaryIndexesCapacityMap =
    Map[IndexName, zio.aws.dynamodb.model.Capacity]
  type StringSetAttributeValue = List[StringAttributeValue]
  type TableNameList = List[TableName]
  type TagKeyList = List[TagKeyString]
  type TagList = List[zio.aws.dynamodb.model.Tag]
  type TransactGetItemList = List[zio.aws.dynamodb.model.TransactGetItem]
  type TransactWriteItemList = List[zio.aws.dynamodb.model.TransactWriteItem]
  type WriteRequests = List[zio.aws.dynamodb.model.WriteRequest]
}
