package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class AttachmentStateChange(attachmentArn: String, status: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.AttachmentStateChange = {
    import AttachmentStateChange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.AttachmentStateChange
      .builder()
      .attachmentArn(attachmentArn: java.lang.String)
      .status(status: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.AttachmentStateChange.ReadOnly =
    zio.aws.ecs.model.AttachmentStateChange.wrap(buildAwsValue())
}
object AttachmentStateChange {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.AttachmentStateChange
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.AttachmentStateChange =
      zio.aws.ecs.model.AttachmentStateChange(attachmentArn, status)
    def attachmentArn: String
    def status: String
    def getAttachmentArn: ZIO[Any, Nothing, String] = ZIO.succeed(attachmentArn)
    def getStatus: ZIO[Any, Nothing, String] = ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.AttachmentStateChange
  ) extends zio.aws.ecs.model.AttachmentStateChange.ReadOnly {
    override val attachmentArn: String = impl.attachmentArn(): String
    override val status: String = impl.status(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.AttachmentStateChange
  ): zio.aws.ecs.model.AttachmentStateChange.ReadOnly = new Wrapper(impl)
}
