package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CapacityProvider(
    capacityProviderArn: Option[String] = None,
    name: Option[String] = None,
    status: Option[zio.aws.ecs.model.CapacityProviderStatus] = None,
    autoScalingGroupProvider: Option[
      zio.aws.ecs.model.AutoScalingGroupProvider
    ] = None,
    updateStatus: Option[zio.aws.ecs.model.CapacityProviderUpdateStatus] = None,
    updateStatusReason: Option[String] = None,
    tags: Option[Iterable[zio.aws.ecs.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.CapacityProvider = {
    import CapacityProvider.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.CapacityProvider
      .builder()
      .optionallyWith(
        capacityProviderArn.map(value => value: java.lang.String)
      )(_.capacityProviderArn)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        autoScalingGroupProvider.map(value => value.buildAwsValue())
      )(_.autoScalingGroupProvider)
      .optionallyWith(updateStatus.map(value => value.unwrap))(_.updateStatus)
      .optionallyWith(updateStatusReason.map(value => value: java.lang.String))(
        _.updateStatusReason
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.CapacityProvider.ReadOnly =
    zio.aws.ecs.model.CapacityProvider.wrap(buildAwsValue())
}
object CapacityProvider {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.CapacityProvider
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.CapacityProvider =
      zio.aws.ecs.model.CapacityProvider(
        capacityProviderArn.map(value => value),
        name.map(value => value),
        status.map(value => value),
        autoScalingGroupProvider.map(value => value.asEditable),
        updateStatus.map(value => value),
        updateStatusReason.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def capacityProviderArn: Option[String]
    def name: Option[String]
    def status: Option[zio.aws.ecs.model.CapacityProviderStatus]
    def autoScalingGroupProvider
        : Option[zio.aws.ecs.model.AutoScalingGroupProvider.ReadOnly]
    def updateStatus: Option[zio.aws.ecs.model.CapacityProviderUpdateStatus]
    def updateStatusReason: Option[String]
    def tags: Option[List[zio.aws.ecs.model.Tag.ReadOnly]]
    def getCapacityProviderArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("capacityProviderArn", capacityProviderArn)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.ecs.model.CapacityProviderStatus] =
      AwsError.unwrapOptionField("status", status)
    def getAutoScalingGroupProvider: ZIO[
      Any,
      AwsError,
      zio.aws.ecs.model.AutoScalingGroupProvider.ReadOnly
    ] = AwsError.unwrapOptionField(
      "autoScalingGroupProvider",
      autoScalingGroupProvider
    )
    def getUpdateStatus
        : ZIO[Any, AwsError, zio.aws.ecs.model.CapacityProviderUpdateStatus] =
      AwsError.unwrapOptionField("updateStatus", updateStatus)
    def getUpdateStatusReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("updateStatusReason", updateStatusReason)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ecs.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.CapacityProvider
  ) extends zio.aws.ecs.model.CapacityProvider.ReadOnly {
    override val capacityProviderArn: Option[String] =
      scala.Option(impl.capacityProviderArn()).map(value => value: String)
    override val name: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override val status: Option[zio.aws.ecs.model.CapacityProviderStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.ecs.model.CapacityProviderStatus.wrap(value))
    override val autoScalingGroupProvider
        : Option[zio.aws.ecs.model.AutoScalingGroupProvider.ReadOnly] = scala
      .Option(impl.autoScalingGroupProvider())
      .map(value => zio.aws.ecs.model.AutoScalingGroupProvider.wrap(value))
    override val updateStatus
        : Option[zio.aws.ecs.model.CapacityProviderUpdateStatus] = scala
      .Option(impl.updateStatus())
      .map(value => zio.aws.ecs.model.CapacityProviderUpdateStatus.wrap(value))
    override val updateStatusReason: Option[String] =
      scala.Option(impl.updateStatusReason()).map(value => value: String)
    override val tags: Option[List[zio.aws.ecs.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.CapacityProvider
  ): zio.aws.ecs.model.CapacityProvider.ReadOnly = new Wrapper(impl)
}
