package zio.aws.ecs.model
import zio.aws.ecs.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Cluster(
    clusterArn: Option[String] = None,
    clusterName: Option[String] = None,
    configuration: Option[zio.aws.ecs.model.ClusterConfiguration] = None,
    status: Option[String] = None,
    registeredContainerInstancesCount: Option[Integer] = None,
    runningTasksCount: Option[Integer] = None,
    pendingTasksCount: Option[Integer] = None,
    activeServicesCount: Option[Integer] = None,
    statistics: Option[Iterable[zio.aws.ecs.model.KeyValuePair]] = None,
    tags: Option[Iterable[zio.aws.ecs.model.Tag]] = None,
    settings: Option[Iterable[zio.aws.ecs.model.ClusterSetting]] = None,
    capacityProviders: Option[Iterable[String]] = None,
    defaultCapacityProviderStrategy: Option[
      Iterable[zio.aws.ecs.model.CapacityProviderStrategyItem]
    ] = None,
    attachments: Option[Iterable[zio.aws.ecs.model.Attachment]] = None,
    attachmentsStatus: Option[String] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.ecs.model.Cluster = {
    import Cluster.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.Cluster
      .builder()
      .optionallyWith(clusterArn.map(value => value: java.lang.String))(
        _.clusterArn
      )
      .optionallyWith(clusterName.map(value => value: java.lang.String))(
        _.clusterName
      )
      .optionallyWith(configuration.map(value => value.buildAwsValue()))(
        _.configuration
      )
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(
        registeredContainerInstancesCount.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.registeredContainerInstancesCount)
      .optionallyWith(
        runningTasksCount.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.runningTasksCount)
      .optionallyWith(
        pendingTasksCount.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.pendingTasksCount)
      .optionallyWith(
        activeServicesCount.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.activeServicesCount)
      .optionallyWith(
        statistics.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.statistics)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        settings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.settings)
      .optionallyWith(
        capacityProviders.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.capacityProviders)
      .optionallyWith(
        defaultCapacityProviderStrategy.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.defaultCapacityProviderStrategy)
      .optionallyWith(
        attachments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attachments)
      .optionallyWith(attachmentsStatus.map(value => value: java.lang.String))(
        _.attachmentsStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.Cluster.ReadOnly =
    zio.aws.ecs.model.Cluster.wrap(buildAwsValue())
}
object Cluster {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ecs.model.Cluster] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.Cluster = zio.aws.ecs.model.Cluster(
      clusterArn.map(value => value),
      clusterName.map(value => value),
      configuration.map(value => value.asEditable),
      status.map(value => value),
      registeredContainerInstancesCount.map(value => value),
      runningTasksCount.map(value => value),
      pendingTasksCount.map(value => value),
      activeServicesCount.map(value => value),
      statistics.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      tags.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      settings.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      capacityProviders.map(value => value),
      defaultCapacityProviderStrategy.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      attachments.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      attachmentsStatus.map(value => value)
    )
    def clusterArn: Option[String]
    def clusterName: Option[String]
    def configuration: Option[zio.aws.ecs.model.ClusterConfiguration.ReadOnly]
    def status: Option[String]
    def registeredContainerInstancesCount: Option[Integer]
    def runningTasksCount: Option[Integer]
    def pendingTasksCount: Option[Integer]
    def activeServicesCount: Option[Integer]
    def statistics: Option[List[zio.aws.ecs.model.KeyValuePair.ReadOnly]]
    def tags: Option[List[zio.aws.ecs.model.Tag.ReadOnly]]
    def settings: Option[List[zio.aws.ecs.model.ClusterSetting.ReadOnly]]
    def capacityProviders: Option[List[String]]
    def defaultCapacityProviderStrategy
        : Option[List[zio.aws.ecs.model.CapacityProviderStrategyItem.ReadOnly]]
    def attachments: Option[List[zio.aws.ecs.model.Attachment.ReadOnly]]
    def attachmentsStatus: Option[String]
    def getClusterArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterArn", clusterArn)
    def getClusterName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterName", clusterName)
    def getConfiguration
        : ZIO[Any, AwsError, zio.aws.ecs.model.ClusterConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("configuration", configuration)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getRegisteredContainerInstancesCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "registeredContainerInstancesCount",
        registeredContainerInstancesCount
      )
    def getRunningTasksCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("runningTasksCount", runningTasksCount)
    def getPendingTasksCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("pendingTasksCount", pendingTasksCount)
    def getActiveServicesCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("activeServicesCount", activeServicesCount)
    def getStatistics
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.KeyValuePair.ReadOnly]] =
      AwsError.unwrapOptionField("statistics", statistics)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ecs.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getSettings
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.ClusterSetting.ReadOnly]] =
      AwsError.unwrapOptionField("settings", settings)
    def getCapacityProviders: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("capacityProviders", capacityProviders)
    def getDefaultCapacityProviderStrategy: ZIO[Any, AwsError, List[
      zio.aws.ecs.model.CapacityProviderStrategyItem.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "defaultCapacityProviderStrategy",
      defaultCapacityProviderStrategy
    )
    def getAttachments
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.Attachment.ReadOnly]] =
      AwsError.unwrapOptionField("attachments", attachments)
    def getAttachmentsStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("attachmentsStatus", attachmentsStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.Cluster
  ) extends zio.aws.ecs.model.Cluster.ReadOnly {
    override val clusterArn: Option[String] =
      scala.Option(impl.clusterArn()).map(value => value: String)
    override val clusterName: Option[String] =
      scala.Option(impl.clusterName()).map(value => value: String)
    override val configuration
        : Option[zio.aws.ecs.model.ClusterConfiguration.ReadOnly] = scala
      .Option(impl.configuration())
      .map(value => zio.aws.ecs.model.ClusterConfiguration.wrap(value))
    override val status: Option[String] =
      scala.Option(impl.status()).map(value => value: String)
    override val registeredContainerInstancesCount: Option[Integer] = scala
      .Option(impl.registeredContainerInstancesCount())
      .map(value => zio.aws.ecs.model.primitives.Integer(value))
    override val runningTasksCount: Option[Integer] = scala
      .Option(impl.runningTasksCount())
      .map(value => zio.aws.ecs.model.primitives.Integer(value))
    override val pendingTasksCount: Option[Integer] = scala
      .Option(impl.pendingTasksCount())
      .map(value => zio.aws.ecs.model.primitives.Integer(value))
    override val activeServicesCount: Option[Integer] = scala
      .Option(impl.activeServicesCount())
      .map(value => zio.aws.ecs.model.primitives.Integer(value))
    override val statistics
        : Option[List[zio.aws.ecs.model.KeyValuePair.ReadOnly]] = scala
      .Option(impl.statistics())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.KeyValuePair.wrap(item)
        }.toList
      )
    override val tags: Option[List[zio.aws.ecs.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.Tag.wrap(item)
        }.toList
      )
    override val settings
        : Option[List[zio.aws.ecs.model.ClusterSetting.ReadOnly]] = scala
      .Option(impl.settings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.ClusterSetting.wrap(item)
        }.toList
      )
    override val capacityProviders: Option[List[String]] = scala
      .Option(impl.capacityProviders())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val defaultCapacityProviderStrategy: Option[
      List[zio.aws.ecs.model.CapacityProviderStrategyItem.ReadOnly]
    ] = scala
      .Option(impl.defaultCapacityProviderStrategy())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.CapacityProviderStrategyItem.wrap(item)
        }.toList
      )
    override val attachments
        : Option[List[zio.aws.ecs.model.Attachment.ReadOnly]] = scala
      .Option(impl.attachments())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.Attachment.wrap(item)
        }.toList
      )
    override val attachmentsStatus: Option[String] =
      scala.Option(impl.attachmentsStatus()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.Cluster
  ): zio.aws.ecs.model.Cluster.ReadOnly = new Wrapper(impl)
}
