package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ContainerInstanceHealthStatus(
    overallStatus: Option[zio.aws.ecs.model.InstanceHealthCheckState] = None,
    details: Option[Iterable[zio.aws.ecs.model.InstanceHealthCheckResult]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.ContainerInstanceHealthStatus = {
    import ContainerInstanceHealthStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.ContainerInstanceHealthStatus
      .builder()
      .optionallyWith(overallStatus.map(value => value.unwrap))(_.overallStatus)
      .optionallyWith(
        details.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.details)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.ContainerInstanceHealthStatus.ReadOnly =
    zio.aws.ecs.model.ContainerInstanceHealthStatus.wrap(buildAwsValue())
}
object ContainerInstanceHealthStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.ContainerInstanceHealthStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.ContainerInstanceHealthStatus =
      zio.aws.ecs.model.ContainerInstanceHealthStatus(
        overallStatus.map(value => value),
        details.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def overallStatus: Option[zio.aws.ecs.model.InstanceHealthCheckState]
    def details
        : Option[List[zio.aws.ecs.model.InstanceHealthCheckResult.ReadOnly]]
    def getOverallStatus
        : ZIO[Any, AwsError, zio.aws.ecs.model.InstanceHealthCheckState] =
      AwsError.unwrapOptionField("overallStatus", overallStatus)
    def getDetails: ZIO[Any, AwsError, List[
      zio.aws.ecs.model.InstanceHealthCheckResult.ReadOnly
    ]] = AwsError.unwrapOptionField("details", details)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.ContainerInstanceHealthStatus
  ) extends zio.aws.ecs.model.ContainerInstanceHealthStatus.ReadOnly {
    override val overallStatus
        : Option[zio.aws.ecs.model.InstanceHealthCheckState] = scala
      .Option(impl.overallStatus())
      .map(value => zio.aws.ecs.model.InstanceHealthCheckState.wrap(value))
    override val details
        : Option[List[zio.aws.ecs.model.InstanceHealthCheckResult.ReadOnly]] =
      scala
        .Option(impl.details())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.InstanceHealthCheckResult.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.ContainerInstanceHealthStatus
  ): zio.aws.ecs.model.ContainerInstanceHealthStatus.ReadOnly = new Wrapper(
    impl
  )
}
