package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateTaskSetRequest(
    service: String,
    cluster: String,
    externalId: Option[String] = None,
    taskDefinition: String,
    networkConfiguration: Option[zio.aws.ecs.model.NetworkConfiguration] = None,
    loadBalancers: Option[Iterable[zio.aws.ecs.model.LoadBalancer]] = None,
    serviceRegistries: Option[Iterable[zio.aws.ecs.model.ServiceRegistry]] =
      None,
    launchType: Option[zio.aws.ecs.model.LaunchType] = None,
    capacityProviderStrategy: Option[
      Iterable[zio.aws.ecs.model.CapacityProviderStrategyItem]
    ] = None,
    platformVersion: Option[String] = None,
    scale: Option[zio.aws.ecs.model.Scale] = None,
    clientToken: Option[String] = None,
    tags: Option[Iterable[zio.aws.ecs.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.CreateTaskSetRequest = {
    import CreateTaskSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.CreateTaskSetRequest
      .builder()
      .service(service: java.lang.String)
      .cluster(cluster: java.lang.String)
      .optionallyWith(externalId.map(value => value: java.lang.String))(
        _.externalId
      )
      .taskDefinition(taskDefinition: java.lang.String)
      .optionallyWith(networkConfiguration.map(value => value.buildAwsValue()))(
        _.networkConfiguration
      )
      .optionallyWith(
        loadBalancers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.loadBalancers)
      .optionallyWith(
        serviceRegistries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.serviceRegistries)
      .optionallyWith(launchType.map(value => value.unwrap))(_.launchType)
      .optionallyWith(
        capacityProviderStrategy.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.capacityProviderStrategy)
      .optionallyWith(platformVersion.map(value => value: java.lang.String))(
        _.platformVersion
      )
      .optionallyWith(scale.map(value => value.buildAwsValue()))(_.scale)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.CreateTaskSetRequest.ReadOnly =
    zio.aws.ecs.model.CreateTaskSetRequest.wrap(buildAwsValue())
}
object CreateTaskSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.CreateTaskSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.CreateTaskSetRequest =
      zio.aws.ecs.model.CreateTaskSetRequest(
        service,
        cluster,
        externalId.map(value => value),
        taskDefinition,
        networkConfiguration.map(value => value.asEditable),
        loadBalancers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        serviceRegistries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        launchType.map(value => value),
        capacityProviderStrategy.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        platformVersion.map(value => value),
        scale.map(value => value.asEditable),
        clientToken.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def service: String
    def cluster: String
    def externalId: Option[String]
    def taskDefinition: String
    def networkConfiguration
        : Option[zio.aws.ecs.model.NetworkConfiguration.ReadOnly]
    def loadBalancers: Option[List[zio.aws.ecs.model.LoadBalancer.ReadOnly]]
    def serviceRegistries
        : Option[List[zio.aws.ecs.model.ServiceRegistry.ReadOnly]]
    def launchType: Option[zio.aws.ecs.model.LaunchType]
    def capacityProviderStrategy
        : Option[List[zio.aws.ecs.model.CapacityProviderStrategyItem.ReadOnly]]
    def platformVersion: Option[String]
    def scale: Option[zio.aws.ecs.model.Scale.ReadOnly]
    def clientToken: Option[String]
    def tags: Option[List[zio.aws.ecs.model.Tag.ReadOnly]]
    def getService: ZIO[Any, Nothing, String] = ZIO.succeed(service)
    def getCluster: ZIO[Any, Nothing, String] = ZIO.succeed(cluster)
    def getExternalId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("externalId", externalId)
    def getTaskDefinition: ZIO[Any, Nothing, String] =
      ZIO.succeed(taskDefinition)
    def getNetworkConfiguration
        : ZIO[Any, AwsError, zio.aws.ecs.model.NetworkConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("networkConfiguration", networkConfiguration)
    def getLoadBalancers
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.LoadBalancer.ReadOnly]] =
      AwsError.unwrapOptionField("loadBalancers", loadBalancers)
    def getServiceRegistries
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.ServiceRegistry.ReadOnly]] =
      AwsError.unwrapOptionField("serviceRegistries", serviceRegistries)
    def getLaunchType: ZIO[Any, AwsError, zio.aws.ecs.model.LaunchType] =
      AwsError.unwrapOptionField("launchType", launchType)
    def getCapacityProviderStrategy: ZIO[Any, AwsError, List[
      zio.aws.ecs.model.CapacityProviderStrategyItem.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "capacityProviderStrategy",
      capacityProviderStrategy
    )
    def getPlatformVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("platformVersion", platformVersion)
    def getScale: ZIO[Any, AwsError, zio.aws.ecs.model.Scale.ReadOnly] =
      AwsError.unwrapOptionField("scale", scale)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ecs.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.CreateTaskSetRequest
  ) extends zio.aws.ecs.model.CreateTaskSetRequest.ReadOnly {
    override val service: String = impl.service(): String
    override val cluster: String = impl.cluster(): String
    override val externalId: Option[String] =
      scala.Option(impl.externalId()).map(value => value: String)
    override val taskDefinition: String = impl.taskDefinition(): String
    override val networkConfiguration
        : Option[zio.aws.ecs.model.NetworkConfiguration.ReadOnly] = scala
      .Option(impl.networkConfiguration())
      .map(value => zio.aws.ecs.model.NetworkConfiguration.wrap(value))
    override val loadBalancers
        : Option[List[zio.aws.ecs.model.LoadBalancer.ReadOnly]] = scala
      .Option(impl.loadBalancers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.LoadBalancer.wrap(item)
        }.toList
      )
    override val serviceRegistries
        : Option[List[zio.aws.ecs.model.ServiceRegistry.ReadOnly]] = scala
      .Option(impl.serviceRegistries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.ServiceRegistry.wrap(item)
        }.toList
      )
    override val launchType: Option[zio.aws.ecs.model.LaunchType] = scala
      .Option(impl.launchType())
      .map(value => zio.aws.ecs.model.LaunchType.wrap(value))
    override val capacityProviderStrategy: Option[
      List[zio.aws.ecs.model.CapacityProviderStrategyItem.ReadOnly]
    ] = scala
      .Option(impl.capacityProviderStrategy())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.CapacityProviderStrategyItem.wrap(item)
        }.toList
      )
    override val platformVersion: Option[String] =
      scala.Option(impl.platformVersion()).map(value => value: String)
    override val scale: Option[zio.aws.ecs.model.Scale.ReadOnly] = scala
      .Option(impl.scale())
      .map(value => zio.aws.ecs.model.Scale.wrap(value))
    override val clientToken: Option[String] =
      scala.Option(impl.clientToken()).map(value => value: String)
    override val tags: Option[List[zio.aws.ecs.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.CreateTaskSetRequest
  ): zio.aws.ecs.model.CreateTaskSetRequest.ReadOnly = new Wrapper(impl)
}
