package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeleteAccountSettingRequest(
    name: zio.aws.ecs.model.SettingName,
    principalArn: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.DeleteAccountSettingRequest = {
    import DeleteAccountSettingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.DeleteAccountSettingRequest
      .builder()
      .name(name.unwrap)
      .optionallyWith(principalArn.map(value => value: java.lang.String))(
        _.principalArn
      )
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.DeleteAccountSettingRequest.ReadOnly =
    zio.aws.ecs.model.DeleteAccountSettingRequest.wrap(buildAwsValue())
}
object DeleteAccountSettingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.DeleteAccountSettingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.DeleteAccountSettingRequest =
      zio.aws.ecs.model
        .DeleteAccountSettingRequest(name, principalArn.map(value => value))
    def name: zio.aws.ecs.model.SettingName
    def principalArn: Option[String]
    def getName: ZIO[Any, Nothing, zio.aws.ecs.model.SettingName] =
      ZIO.succeed(name)
    def getPrincipalArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("principalArn", principalArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.DeleteAccountSettingRequest
  ) extends zio.aws.ecs.model.DeleteAccountSettingRequest.ReadOnly {
    override val name: zio.aws.ecs.model.SettingName =
      zio.aws.ecs.model.SettingName.wrap(impl.name())
    override val principalArn: Option[String] =
      scala.Option(impl.principalArn()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.DeleteAccountSettingRequest
  ): zio.aws.ecs.model.DeleteAccountSettingRequest.ReadOnly = new Wrapper(impl)
}
