package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteClusterRequest(cluster: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.DeleteClusterRequest = {
    import DeleteClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.DeleteClusterRequest
      .builder()
      .cluster(cluster: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.DeleteClusterRequest.ReadOnly =
    zio.aws.ecs.model.DeleteClusterRequest.wrap(buildAwsValue())
}
object DeleteClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.DeleteClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.DeleteClusterRequest =
      zio.aws.ecs.model.DeleteClusterRequest(cluster)
    def cluster: String
    def getCluster: ZIO[Any, Nothing, String] = ZIO.succeed(cluster)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.DeleteClusterRequest
  ) extends zio.aws.ecs.model.DeleteClusterRequest.ReadOnly {
    override val cluster: String = impl.cluster(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.DeleteClusterRequest
  ): zio.aws.ecs.model.DeleteClusterRequest.ReadOnly = new Wrapper(impl)
}
