package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeleteServiceResponse(
    service: Option[zio.aws.ecs.model.Service] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.DeleteServiceResponse = {
    import DeleteServiceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.DeleteServiceResponse
      .builder()
      .optionallyWith(service.map(value => value.buildAwsValue()))(_.service)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.DeleteServiceResponse.ReadOnly =
    zio.aws.ecs.model.DeleteServiceResponse.wrap(buildAwsValue())
}
object DeleteServiceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.DeleteServiceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.DeleteServiceResponse = zio.aws.ecs.model
      .DeleteServiceResponse(service.map(value => value.asEditable))
    def service: Option[zio.aws.ecs.model.Service.ReadOnly]
    def getService: ZIO[Any, AwsError, zio.aws.ecs.model.Service.ReadOnly] =
      AwsError.unwrapOptionField("service", service)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.DeleteServiceResponse
  ) extends zio.aws.ecs.model.DeleteServiceResponse.ReadOnly {
    override val service: Option[zio.aws.ecs.model.Service.ReadOnly] = scala
      .Option(impl.service())
      .map(value => zio.aws.ecs.model.Service.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.DeleteServiceResponse
  ): zio.aws.ecs.model.DeleteServiceResponse.ReadOnly = new Wrapper(impl)
}
