package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeleteTaskSetResponse(
    taskSet: Option[zio.aws.ecs.model.TaskSet] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.DeleteTaskSetResponse = {
    import DeleteTaskSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.DeleteTaskSetResponse
      .builder()
      .optionallyWith(taskSet.map(value => value.buildAwsValue()))(_.taskSet)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.DeleteTaskSetResponse.ReadOnly =
    zio.aws.ecs.model.DeleteTaskSetResponse.wrap(buildAwsValue())
}
object DeleteTaskSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.DeleteTaskSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.DeleteTaskSetResponse = zio.aws.ecs.model
      .DeleteTaskSetResponse(taskSet.map(value => value.asEditable))
    def taskSet: Option[zio.aws.ecs.model.TaskSet.ReadOnly]
    def getTaskSet: ZIO[Any, AwsError, zio.aws.ecs.model.TaskSet.ReadOnly] =
      AwsError.unwrapOptionField("taskSet", taskSet)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.DeleteTaskSetResponse
  ) extends zio.aws.ecs.model.DeleteTaskSetResponse.ReadOnly {
    override val taskSet: Option[zio.aws.ecs.model.TaskSet.ReadOnly] = scala
      .Option(impl.taskSet())
      .map(value => zio.aws.ecs.model.TaskSet.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.DeleteTaskSetResponse
  ): zio.aws.ecs.model.DeleteTaskSetResponse.ReadOnly = new Wrapper(impl)
}
