package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Device(
    hostPath: String,
    containerPath: Option[String] = None,
    permissions: Option[Iterable[zio.aws.ecs.model.DeviceCgroupPermission]] =
      None
) {
  def buildAwsValue(): software.amazon.awssdk.services.ecs.model.Device = {
    import Device.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.Device
      .builder()
      .hostPath(hostPath: java.lang.String)
      .optionallyWith(containerPath.map(value => value: java.lang.String))(
        _.containerPath
      )
      .optionallyWith(
        permissions.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.permissionsWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.Device.ReadOnly =
    zio.aws.ecs.model.Device.wrap(buildAwsValue())
}
object Device {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ecs.model.Device] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.Device = zio.aws.ecs.model.Device(
      hostPath,
      containerPath.map(value => value),
      permissions.map(value => value)
    )
    def hostPath: String
    def containerPath: Option[String]
    def permissions: Option[List[zio.aws.ecs.model.DeviceCgroupPermission]]
    def getHostPath: ZIO[Any, Nothing, String] = ZIO.succeed(hostPath)
    def getContainerPath: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("containerPath", containerPath)
    def getPermissions
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.DeviceCgroupPermission]] =
      AwsError.unwrapOptionField("permissions", permissions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.Device
  ) extends zio.aws.ecs.model.Device.ReadOnly {
    override val hostPath: String = impl.hostPath(): String
    override val containerPath: Option[String] =
      scala.Option(impl.containerPath()).map(value => value: String)
    override val permissions
        : Option[List[zio.aws.ecs.model.DeviceCgroupPermission]] = scala
      .Option(impl.permissions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.DeviceCgroupPermission.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.Device
  ): zio.aws.ecs.model.Device.ReadOnly = new Wrapper(impl)
}
