package zio.aws.ecs.model
import scala.jdk.CollectionConverters.*
sealed trait DeviceCgroupPermission {
  def unwrap: software.amazon.awssdk.services.ecs.model.DeviceCgroupPermission
}
object DeviceCgroupPermission {
  def wrap(
      value: software.amazon.awssdk.services.ecs.model.DeviceCgroupPermission
  ): zio.aws.ecs.model.DeviceCgroupPermission = value match {
    case software.amazon.awssdk.services.ecs.model.DeviceCgroupPermission.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ecs.model.DeviceCgroupPermission.READ =>
      val r = read
      r
    case software.amazon.awssdk.services.ecs.model.DeviceCgroupPermission.WRITE =>
      val r = write
      r
    case software.amazon.awssdk.services.ecs.model.DeviceCgroupPermission.MKNOD =>
      val r = mknod
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ecs.model.DeviceCgroupPermission {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.DeviceCgroupPermission =
      software.amazon.awssdk.services.ecs.model.DeviceCgroupPermission.UNKNOWN_TO_SDK_VERSION
  }
  case object read extends zio.aws.ecs.model.DeviceCgroupPermission {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.DeviceCgroupPermission =
      software.amazon.awssdk.services.ecs.model.DeviceCgroupPermission.READ
  }
  case object write extends zio.aws.ecs.model.DeviceCgroupPermission {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.DeviceCgroupPermission =
      software.amazon.awssdk.services.ecs.model.DeviceCgroupPermission.WRITE
  }
  case object mknod extends zio.aws.ecs.model.DeviceCgroupPermission {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.DeviceCgroupPermission =
      software.amazon.awssdk.services.ecs.model.DeviceCgroupPermission.MKNOD
  }
}
