package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DiscoverPollEndpointRequest(
    containerInstance: Option[String] = None,
    cluster: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.DiscoverPollEndpointRequest = {
    import DiscoverPollEndpointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.DiscoverPollEndpointRequest
      .builder()
      .optionallyWith(containerInstance.map(value => value: java.lang.String))(
        _.containerInstance
      )
      .optionallyWith(cluster.map(value => value: java.lang.String))(_.cluster)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.DiscoverPollEndpointRequest.ReadOnly =
    zio.aws.ecs.model.DiscoverPollEndpointRequest.wrap(buildAwsValue())
}
object DiscoverPollEndpointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.DiscoverPollEndpointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.DiscoverPollEndpointRequest =
      zio.aws.ecs.model.DiscoverPollEndpointRequest(
        containerInstance.map(value => value),
        cluster.map(value => value)
      )
    def containerInstance: Option[String]
    def cluster: Option[String]
    def getContainerInstance: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("containerInstance", containerInstance)
    def getCluster: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cluster", cluster)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.DiscoverPollEndpointRequest
  ) extends zio.aws.ecs.model.DiscoverPollEndpointRequest.ReadOnly {
    override val containerInstance: Option[String] =
      scala.Option(impl.containerInstance()).map(value => value: String)
    override val cluster: Option[String] =
      scala.Option(impl.cluster()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.DiscoverPollEndpointRequest
  ): zio.aws.ecs.model.DiscoverPollEndpointRequest.ReadOnly = new Wrapper(impl)
}
