package zio.aws.ecs.model
import zio.aws.ecs.model.primitives.BoxedBoolean
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DockerVolumeConfiguration(
    scope: Option[zio.aws.ecs.model.Scope] = None,
    autoprovision: Option[BoxedBoolean] = None,
    driver: Option[String] = None,
    driverOpts: Option[Map[String, String]] = None,
    labels: Option[Map[String, String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.DockerVolumeConfiguration = {
    import DockerVolumeConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.DockerVolumeConfiguration
      .builder()
      .optionallyWith(scope.map(value => value.unwrap))(_.scope)
      .optionallyWith(
        autoprovision.map(value =>
          BoxedBoolean.unwrap(value): java.lang.Boolean
        )
      )(_.autoprovision)
      .optionallyWith(driver.map(value => value: java.lang.String))(_.driver)
      .optionallyWith(
        driverOpts.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.driverOpts)
      .optionallyWith(
        labels.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.labels)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.DockerVolumeConfiguration.ReadOnly =
    zio.aws.ecs.model.DockerVolumeConfiguration.wrap(buildAwsValue())
}
object DockerVolumeConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.DockerVolumeConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.DockerVolumeConfiguration =
      zio.aws.ecs.model.DockerVolumeConfiguration(
        scope.map(value => value),
        autoprovision.map(value => value),
        driver.map(value => value),
        driverOpts.map(value => value),
        labels.map(value => value)
      )
    def scope: Option[zio.aws.ecs.model.Scope]
    def autoprovision: Option[BoxedBoolean]
    def driver: Option[String]
    def driverOpts: Option[Map[String, String]]
    def labels: Option[Map[String, String]]
    def getScope: ZIO[Any, AwsError, zio.aws.ecs.model.Scope] =
      AwsError.unwrapOptionField("scope", scope)
    def getAutoprovision: ZIO[Any, AwsError, BoxedBoolean] =
      AwsError.unwrapOptionField("autoprovision", autoprovision)
    def getDriver: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("driver", driver)
    def getDriverOpts: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("driverOpts", driverOpts)
    def getLabels: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("labels", labels)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.DockerVolumeConfiguration
  ) extends zio.aws.ecs.model.DockerVolumeConfiguration.ReadOnly {
    override val scope: Option[zio.aws.ecs.model.Scope] = scala
      .Option(impl.scope())
      .map(value => zio.aws.ecs.model.Scope.wrap(value))
    override val autoprovision: Option[BoxedBoolean] = scala
      .Option(impl.autoprovision())
      .map(value => zio.aws.ecs.model.primitives.BoxedBoolean(value))
    override val driver: Option[String] =
      scala.Option(impl.driver()).map(value => value: String)
    override val driverOpts: Option[Map[String, String]] = scala
      .Option(impl.driverOpts())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val labels: Option[Map[String, String]] = scala
      .Option(impl.labels())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.DockerVolumeConfiguration
  ): zio.aws.ecs.model.DockerVolumeConfiguration.ReadOnly = new Wrapper(impl)
}
