package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class EFSAuthorizationConfig(
    accessPointId: Option[String] = None,
    iam: Option[zio.aws.ecs.model.EFSAuthorizationConfigIAM] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.EFSAuthorizationConfig = {
    import EFSAuthorizationConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.EFSAuthorizationConfig
      .builder()
      .optionallyWith(accessPointId.map(value => value: java.lang.String))(
        _.accessPointId
      )
      .optionallyWith(iam.map(value => value.unwrap))(_.iam)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.EFSAuthorizationConfig.ReadOnly =
    zio.aws.ecs.model.EFSAuthorizationConfig.wrap(buildAwsValue())
}
object EFSAuthorizationConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.EFSAuthorizationConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.EFSAuthorizationConfig =
      zio.aws.ecs.model.EFSAuthorizationConfig(
        accessPointId.map(value => value),
        iam.map(value => value)
      )
    def accessPointId: Option[String]
    def iam: Option[zio.aws.ecs.model.EFSAuthorizationConfigIAM]
    def getAccessPointId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("accessPointId", accessPointId)
    def getIam
        : ZIO[Any, AwsError, zio.aws.ecs.model.EFSAuthorizationConfigIAM] =
      AwsError.unwrapOptionField("iam", iam)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.EFSAuthorizationConfig
  ) extends zio.aws.ecs.model.EFSAuthorizationConfig.ReadOnly {
    override val accessPointId: Option[String] =
      scala.Option(impl.accessPointId()).map(value => value: String)
    override val iam: Option[zio.aws.ecs.model.EFSAuthorizationConfigIAM] =
      scala
        .Option(impl.iam())
        .map(value => zio.aws.ecs.model.EFSAuthorizationConfigIAM.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.EFSAuthorizationConfig
  ): zio.aws.ecs.model.EFSAuthorizationConfig.ReadOnly = new Wrapper(impl)
}
