package zio.aws.ecs.model
import java.lang.Integer
import zio.aws.ecs.model.primitives.BoxedInteger
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class EFSVolumeConfiguration(
    fileSystemId: String,
    rootDirectory: Option[String] = None,
    transitEncryption: Option[zio.aws.ecs.model.EFSTransitEncryption] = None,
    transitEncryptionPort: Option[BoxedInteger] = None,
    authorizationConfig: Option[zio.aws.ecs.model.EFSAuthorizationConfig] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.EFSVolumeConfiguration = {
    import EFSVolumeConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.EFSVolumeConfiguration
      .builder()
      .fileSystemId(fileSystemId: java.lang.String)
      .optionallyWith(rootDirectory.map(value => value: java.lang.String))(
        _.rootDirectory
      )
      .optionallyWith(transitEncryption.map(value => value.unwrap))(
        _.transitEncryption
      )
      .optionallyWith(
        transitEncryptionPort.map(value => BoxedInteger.unwrap(value): Integer)
      )(_.transitEncryptionPort)
      .optionallyWith(authorizationConfig.map(value => value.buildAwsValue()))(
        _.authorizationConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.EFSVolumeConfiguration.ReadOnly =
    zio.aws.ecs.model.EFSVolumeConfiguration.wrap(buildAwsValue())
}
object EFSVolumeConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.EFSVolumeConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.EFSVolumeConfiguration =
      zio.aws.ecs.model.EFSVolumeConfiguration(
        fileSystemId,
        rootDirectory.map(value => value),
        transitEncryption.map(value => value),
        transitEncryptionPort.map(value => value),
        authorizationConfig.map(value => value.asEditable)
      )
    def fileSystemId: String
    def rootDirectory: Option[String]
    def transitEncryption: Option[zio.aws.ecs.model.EFSTransitEncryption]
    def transitEncryptionPort: Option[BoxedInteger]
    def authorizationConfig
        : Option[zio.aws.ecs.model.EFSAuthorizationConfig.ReadOnly]
    def getFileSystemId: ZIO[Any, Nothing, String] = ZIO.succeed(fileSystemId)
    def getRootDirectory: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("rootDirectory", rootDirectory)
    def getTransitEncryption
        : ZIO[Any, AwsError, zio.aws.ecs.model.EFSTransitEncryption] =
      AwsError.unwrapOptionField("transitEncryption", transitEncryption)
    def getTransitEncryptionPort: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField("transitEncryptionPort", transitEncryptionPort)
    def getAuthorizationConfig: ZIO[
      Any,
      AwsError,
      zio.aws.ecs.model.EFSAuthorizationConfig.ReadOnly
    ] = AwsError.unwrapOptionField("authorizationConfig", authorizationConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.EFSVolumeConfiguration
  ) extends zio.aws.ecs.model.EFSVolumeConfiguration.ReadOnly {
    override val fileSystemId: String = impl.fileSystemId(): String
    override val rootDirectory: Option[String] =
      scala.Option(impl.rootDirectory()).map(value => value: String)
    override val transitEncryption
        : Option[zio.aws.ecs.model.EFSTransitEncryption] = scala
      .Option(impl.transitEncryption())
      .map(value => zio.aws.ecs.model.EFSTransitEncryption.wrap(value))
    override val transitEncryptionPort: Option[BoxedInteger] = scala
      .Option(impl.transitEncryptionPort())
      .map(value => zio.aws.ecs.model.primitives.BoxedInteger(value))
    override val authorizationConfig
        : Option[zio.aws.ecs.model.EFSAuthorizationConfig.ReadOnly] = scala
      .Option(impl.authorizationConfig())
      .map(value => zio.aws.ecs.model.EFSAuthorizationConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.EFSVolumeConfiguration
  ): zio.aws.ecs.model.EFSVolumeConfiguration.ReadOnly = new Wrapper(impl)
}
