package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ExecuteCommandLogConfiguration(
    cloudWatchLogGroupName: Option[String] = None,
    cloudWatchEncryptionEnabled: Option[Boolean] = None,
    s3BucketName: Option[String] = None,
    s3EncryptionEnabled: Option[Boolean] = None,
    s3KeyPrefix: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.ExecuteCommandLogConfiguration = {
    import ExecuteCommandLogConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.ExecuteCommandLogConfiguration
      .builder()
      .optionallyWith(
        cloudWatchLogGroupName.map(value => value: java.lang.String)
      )(_.cloudWatchLogGroupName)
      .optionallyWith(
        cloudWatchEncryptionEnabled.map(value => value: java.lang.Boolean)
      )(_.cloudWatchEncryptionEnabled)
      .optionallyWith(s3BucketName.map(value => value: java.lang.String))(
        _.s3BucketName
      )
      .optionallyWith(
        s3EncryptionEnabled.map(value => value: java.lang.Boolean)
      )(_.s3EncryptionEnabled)
      .optionallyWith(s3KeyPrefix.map(value => value: java.lang.String))(
        _.s3KeyPrefix
      )
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.ExecuteCommandLogConfiguration.ReadOnly =
    zio.aws.ecs.model.ExecuteCommandLogConfiguration.wrap(buildAwsValue())
}
object ExecuteCommandLogConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.ExecuteCommandLogConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.ExecuteCommandLogConfiguration =
      zio.aws.ecs.model.ExecuteCommandLogConfiguration(
        cloudWatchLogGroupName.map(value => value),
        cloudWatchEncryptionEnabled.map(value => value),
        s3BucketName.map(value => value),
        s3EncryptionEnabled.map(value => value),
        s3KeyPrefix.map(value => value)
      )
    def cloudWatchLogGroupName: Option[String]
    def cloudWatchEncryptionEnabled: Option[Boolean]
    def s3BucketName: Option[String]
    def s3EncryptionEnabled: Option[Boolean]
    def s3KeyPrefix: Option[String]
    def getCloudWatchLogGroupName: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("cloudWatchLogGroupName", cloudWatchLogGroupName)
    def getCloudWatchEncryptionEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "cloudWatchEncryptionEnabled",
        cloudWatchEncryptionEnabled
      )
    def getS3BucketName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("s3BucketName", s3BucketName)
    def getS3EncryptionEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("s3EncryptionEnabled", s3EncryptionEnabled)
    def getS3KeyPrefix: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("s3KeyPrefix", s3KeyPrefix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.ExecuteCommandLogConfiguration
  ) extends zio.aws.ecs.model.ExecuteCommandLogConfiguration.ReadOnly {
    override val cloudWatchLogGroupName: Option[String] =
      scala.Option(impl.cloudWatchLogGroupName()).map(value => value: String)
    override val cloudWatchEncryptionEnabled: Option[Boolean] = scala
      .Option(impl.cloudWatchEncryptionEnabled())
      .map(value => value: Boolean)
    override val s3BucketName: Option[String] =
      scala.Option(impl.s3BucketName()).map(value => value: String)
    override val s3EncryptionEnabled: Option[Boolean] =
      scala.Option(impl.s3EncryptionEnabled()).map(value => value: Boolean)
    override val s3KeyPrefix: Option[String] =
      scala.Option(impl.s3KeyPrefix()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.ExecuteCommandLogConfiguration
  ): zio.aws.ecs.model.ExecuteCommandLogConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
