package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ExecuteCommandResponse(
    clusterArn: Option[String] = None,
    containerArn: Option[String] = None,
    containerName: Option[String] = None,
    interactive: Option[Boolean] = None,
    session: Option[zio.aws.ecs.model.Session] = None,
    taskArn: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.ExecuteCommandResponse = {
    import ExecuteCommandResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.ExecuteCommandResponse
      .builder()
      .optionallyWith(clusterArn.map(value => value: java.lang.String))(
        _.clusterArn
      )
      .optionallyWith(containerArn.map(value => value: java.lang.String))(
        _.containerArn
      )
      .optionallyWith(containerName.map(value => value: java.lang.String))(
        _.containerName
      )
      .optionallyWith(interactive.map(value => value: java.lang.Boolean))(
        _.interactive
      )
      .optionallyWith(session.map(value => value.buildAwsValue()))(_.session)
      .optionallyWith(taskArn.map(value => value: java.lang.String))(_.taskArn)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.ExecuteCommandResponse.ReadOnly =
    zio.aws.ecs.model.ExecuteCommandResponse.wrap(buildAwsValue())
}
object ExecuteCommandResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.ExecuteCommandResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.ExecuteCommandResponse =
      zio.aws.ecs.model.ExecuteCommandResponse(
        clusterArn.map(value => value),
        containerArn.map(value => value),
        containerName.map(value => value),
        interactive.map(value => value),
        session.map(value => value.asEditable),
        taskArn.map(value => value)
      )
    def clusterArn: Option[String]
    def containerArn: Option[String]
    def containerName: Option[String]
    def interactive: Option[Boolean]
    def session: Option[zio.aws.ecs.model.Session.ReadOnly]
    def taskArn: Option[String]
    def getClusterArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterArn", clusterArn)
    def getContainerArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("containerArn", containerArn)
    def getContainerName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("containerName", containerName)
    def getInteractive: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("interactive", interactive)
    def getSession: ZIO[Any, AwsError, zio.aws.ecs.model.Session.ReadOnly] =
      AwsError.unwrapOptionField("session", session)
    def getTaskArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("taskArn", taskArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.ExecuteCommandResponse
  ) extends zio.aws.ecs.model.ExecuteCommandResponse.ReadOnly {
    override val clusterArn: Option[String] =
      scala.Option(impl.clusterArn()).map(value => value: String)
    override val containerArn: Option[String] =
      scala.Option(impl.containerArn()).map(value => value: String)
    override val containerName: Option[String] =
      scala.Option(impl.containerName()).map(value => value: String)
    override val interactive: Option[Boolean] =
      scala.Option(impl.interactive()).map(value => value: Boolean)
    override val session: Option[zio.aws.ecs.model.Session.ReadOnly] = scala
      .Option(impl.session())
      .map(value => zio.aws.ecs.model.Session.wrap(value))
    override val taskArn: Option[String] =
      scala.Option(impl.taskArn()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.ExecuteCommandResponse
  ): zio.aws.ecs.model.ExecuteCommandResponse.ReadOnly = new Wrapper(impl)
}
