package zio.aws.ecs.model
import java.lang.Integer
import zio.aws.ecs.model.primitives.BoxedInteger
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class HealthCheck(
    command: Iterable[String],
    interval: Option[BoxedInteger] = None,
    timeout: Option[BoxedInteger] = None,
    retries: Option[BoxedInteger] = None,
    startPeriod: Option[BoxedInteger] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.ecs.model.HealthCheck = {
    import HealthCheck.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.HealthCheck
      .builder()
      .command(command.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        interval.map(value => BoxedInteger.unwrap(value): Integer)
      )(_.interval)
      .optionallyWith(
        timeout.map(value => BoxedInteger.unwrap(value): Integer)
      )(_.timeout)
      .optionallyWith(
        retries.map(value => BoxedInteger.unwrap(value): Integer)
      )(_.retries)
      .optionallyWith(
        startPeriod.map(value => BoxedInteger.unwrap(value): Integer)
      )(_.startPeriod)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.HealthCheck.ReadOnly =
    zio.aws.ecs.model.HealthCheck.wrap(buildAwsValue())
}
object HealthCheck {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ecs.model.HealthCheck] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.HealthCheck =
      zio.aws.ecs.model.HealthCheck(
        command,
        interval.map(value => value),
        timeout.map(value => value),
        retries.map(value => value),
        startPeriod.map(value => value)
      )
    def command: List[String]
    def interval: Option[BoxedInteger]
    def timeout: Option[BoxedInteger]
    def retries: Option[BoxedInteger]
    def startPeriod: Option[BoxedInteger]
    def getCommand: ZIO[Any, Nothing, List[String]] = ZIO.succeed(command)
    def getInterval: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField("interval", interval)
    def getTimeout: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField("timeout", timeout)
    def getRetries: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField("retries", retries)
    def getStartPeriod: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField("startPeriod", startPeriod)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.HealthCheck
  ) extends zio.aws.ecs.model.HealthCheck.ReadOnly {
    override val command: List[String] = impl
      .command()
      .asScala
      .map { item =>
        item: String
      }
      .toList
    override val interval: Option[BoxedInteger] = scala
      .Option(impl.interval())
      .map(value => zio.aws.ecs.model.primitives.BoxedInteger(value))
    override val timeout: Option[BoxedInteger] = scala
      .Option(impl.timeout())
      .map(value => zio.aws.ecs.model.primitives.BoxedInteger(value))
    override val retries: Option[BoxedInteger] = scala
      .Option(impl.retries())
      .map(value => zio.aws.ecs.model.primitives.BoxedInteger(value))
    override val startPeriod: Option[BoxedInteger] = scala
      .Option(impl.startPeriod())
      .map(value => zio.aws.ecs.model.primitives.BoxedInteger(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.HealthCheck
  ): zio.aws.ecs.model.HealthCheck.ReadOnly = new Wrapper(impl)
}
