package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class HostEntry(hostname: String, ipAddress: String) {
  def buildAwsValue(): software.amazon.awssdk.services.ecs.model.HostEntry = {
    import HostEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.HostEntry
      .builder()
      .hostname(hostname: java.lang.String)
      .ipAddress(ipAddress: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.HostEntry.ReadOnly =
    zio.aws.ecs.model.HostEntry.wrap(buildAwsValue())
}
object HostEntry {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ecs.model.HostEntry] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.HostEntry =
      zio.aws.ecs.model.HostEntry(hostname, ipAddress)
    def hostname: String
    def ipAddress: String
    def getHostname: ZIO[Any, Nothing, String] = ZIO.succeed(hostname)
    def getIpAddress: ZIO[Any, Nothing, String] = ZIO.succeed(ipAddress)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.HostEntry
  ) extends zio.aws.ecs.model.HostEntry.ReadOnly {
    override val hostname: String = impl.hostname(): String
    override val ipAddress: String = impl.ipAddress(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.HostEntry
  ): zio.aws.ecs.model.HostEntry.ReadOnly = new Wrapper(impl)
}
